#ifndef		__T_ANALYS_LABELING_H_INCLUDE_
#define		__T_ANALYS_LABELING_H_INCLUDE_

#include "../data/t_label.h"
#include "../common/t_com_mapper.h"
#include <vector>
#include <algorithm>

namespace t_image_engine{

// Cf[^̃xO
class t_analys_labeler
{
public:
	// xf[^t(摜f[^Cf[^)
	inline static bool make_label(
		const t_image_interface& src,
		std::vector<t_label>* labels
	){
		std::vector<t_line> linedata;
		if(t_analys_liner::make_line(src, &linedata)){
			make_label(&linedata, labels);
		}
		return false;
		
	}

	// xf[^t(Cf[^xf[^)
	inline static bool make_label(
		std::vector<t_line>*	linedata,
		std::vector<t_label>*	labels
	)
	{
		// CƂ̃xt(ȈՃxO)
		if(!check_label(linedata)){
			return false;
		}

		// Cf[^xf[^ɓ
		if(!integrate_line2label(linedata, labels)){
			return false;
		}
		// xf[^m̓
		while(integrate_label2label(labels));

		return true;
	}

protected:

	// x\[g
	class label_no_sort_functor
	{
	public:
		inline bool operator()(const t_line& a, const t_line& b) const 
			{ return (b.no_ == a.no_) ? ycomp(a, b) : b.no_ > a.no_;}
	protected:
		inline bool ycomp(const t_line& a, const t_line& b) const
			{ return (b.y_ == a.y_) ? xcomp(a, b) : b.y_ > a.y_;}
		inline bool xcomp(const t_line& a, const t_line& b) const
			{ return b.sx_ > a.sx_;}
	};
protected:

	// אڃCm̃xԍt
	inline static bool check_label(
		std::vector<t_line>* linedata)
	{
		// ̗אڃĈ݃xO
		int labelno = 0;
		for(std::vector<t_line>::iterator its = linedata->begin(); its != linedata->end(); its++){
			for(std::vector<t_line>::iterator itt = its; itt != linedata->end(); itt++){
				if(itt == its || itt->y_ == its->y_){
					continue;
				}

				if(itt->y_ - its->y_ > 1){
					break;
				}

				// אڂf[^̃xt
				if(line_connect(its, itt)){
					// xԍ
					if(its->no_ == 0 && itt->no_ == 0){
						its->no_ = itt->no_ = labelno++;
					// CNoȂ
					}else if(its->no_ == 0){
						its->no_ = itt->no_;
					// ΏۃCNoȂ
					}else if(itt->no_ == 0){
						itt->no_ = its->no_;
					// AΏۗ̃CNoL̏ꍇAxɒu
					}else{
						if(its->no_ == itt->no_){
							continue;
						}else if(its->no_ > itt->no_){
							its->no_ = itt->no_;
						}else if(its->no_ < itt->no_){
							itt->no_ = its->no_;
						}
					}
				}
			}
		}
		
		// x̕tĂȂӏ̃xt
		for(std::vector<t_line>::iterator its = linedata->begin(); its != linedata->end(); its++){
			if(its->no_ == 0){
				its->no_ = labelno++;
			}
		}
		return true;
	}

	// Cf[^烉xւ̓
	inline static bool integrate_line2label(
		std::vector<t_line>* linedata, std::vector<t_label>* labels)
	{
		// xԍɃ\[g
		std::sort(linedata->begin(), linedata->end(), label_no_sort_functor());

		// xƂɐ؂蕪
		std::vector<t_line>::iterator start = linedata->begin();
		std::vector<t_line>::iterator end	= linedata->begin();
		for(std::vector<t_line>::iterator its = linedata->begin(); its != linedata->end(); its++){
			if(its->no_ != start->no_){
				t_label label;
				label.set_line_data(start, end+1);
				labels->push_back(label);
				start = end = its;
			}else{
				end = its;
			}
		}
		return true;
	}

	// xf[^m̓
	inline static bool integrate_label2label(
		std::vector<t_label>* labels)
	{
		typedef std::vector<t_label>::iterator labelit;
		t_com_mapper<labelit> mapper;

		// u\ȃx̃T[`
		for(labelit its = labels->begin(); its != labels->end(); its++){
			for(labelit itt = its+1; itt != labels->end(); itt++){
				// ꍇ̓`FbNȂ
				if(its == itt){
					continue;
				}
				// x̐ڐG`FbN
				if(label_connect(its, itt)){
					// ڐGꍇAxԍ̏ɓ
					if(its->get_label_no() > itt->get_label_no()){
						mapper.map_.push_back(t_com_mapper<labelit>::map_pair(itt, its));
					}else{
						mapper.map_.push_back(t_com_mapper<labelit>::map_pair(its, itt));
					}
				}
			}
		}

		// 郉xȂ
		if(mapper.map_.size() == 0){
			return false;
		}

		// x̓
		for(t_com_mapper<labelit>::map_array::iterator it = mapper.map_.end()-1; it >= mapper.map_.begin(); it--){
			it->first->add_label_data(*(it->second));
			it->second->linedata_.clear();
		}

		// x̍폜
		for(labelit its = labels->begin(); its != labels->end(); its++){
			if(its->linedata_.size() == 0){
				labels->erase(its--);
			}
		}
		return true;
	}

	// Cm̗אڃ`FbN
	inline static bool line_connect(
		std::vector<t_line>::const_iterator a, 
		std::vector<t_line>::const_iterator b
	)
	{
		if(abs(a->y_ - b->y_)==1){
			if(a->sx_ <= b->ex_){
				if(a->ex_ >= b->sx_){
					return true;
				}
			}else if(b->sx_ <= a->ex_){
				if(b->ex_ >= a->sx_){
					return true;
				}
			}
		}
		return false;
	}
	
	// xm̗אڃ`FbN
	inline static bool label_connect(
		const std::vector<t_label>::const_iterator a, 
		const std::vector<t_label>::const_iterator b
	)
	{
		// `mאڂ邩H
		if(a->get_rect_pt()->adjacent(*(b->get_rect_pt()))){
			// a, b̂ꂩ̃Cאڂ邩H
			for(std::vector<t_line>::const_iterator its = a->linedata_.begin(); its != a->linedata_.end(); its++){
				for(std::vector<t_line>::const_iterator itt = b->linedata_.begin(); itt != b->linedata_.end(); itt++){
					if(line_connect(its, itt)){
						return true;
					}
				}
			}
		}
		return false;
	}
	
};


};

#endif
