#ifndef		__T_COM_LINEBUFFER_H_INCLUDE_
#define		__T_COM_LINEBUFFER_H_INCLUDE_

namespace t_image_engine{

template <class _T> class t_com_linebuffer
{
protected:
	_T** linebuffer_;
	int	linewidth_;
	int	linecount_;
public:

	//! RXgN^
	t_com_linebuffer(int linecount, int linewidth)
	{
		// Cobt@
		linebuffer_ = new _T* [linecount];
		for(int i = 0; i < linecount; i++){
			linebuffer_[i] = new _T [linewidth * sizeof(_T)];
		}
		linewidth_ = linewidth;
		linecount_ = linecount;
	}

	//! fXgN^
	~t_com_linebuffer()
	{
		for(int i = 0; i < linecount_; i++){
			if(linebuffer_[i]){
				delete [] linebuffer_[i];
			}
		}
		if(linebuffer_){
			delete [] linebuffer_;
		}
	}
	
	// w胉C̐擪AhX擾
	inline _T* pointer(int count)
	{
		return (count > linecount_) ? NULL : linebuffer_[count];	
	}
};

};
#endif