#ifndef		__T_COM_OPERATOR_H_INCLUDE_
#define		__T_COM_OPERATOR_H_INCLUDE_

// OaZtvZ
namespace t_image_engine{

	//============================================================================
	// LXg֐Q
	//============================================================================
	// int 2 unsigned char
	inline unsigned char i2uc(int val)
		{return (val&0x80000000)?0:(val>0xff?0xff:val);}

	// double 2 unsigned char
	inline unsigned char d2uc(double val)
		{return i2uc(static_cast<int>(val));}

	// float 2 unsigned char
	inline unsigned char f2uc(float val)
		{return i2uc(static_cast<int>(val));}

	// unsigned int 2 unsigned char
	inline unsigned char ui2uc(unsigned int val)
		{return val>0xff?0xff:val;}

	// binary 2 unsigned char
	inline unsigned char bin2uc(unsigned char val, unsigned char pos)
		{return val & bin_mask_table[pos]; }

	//============================================================================
	// OaZt unsigned char vZ
	//============================================================================
	// uc * uc
	inline unsigned char ucm(unsigned char a, unsigned char b)
		{return ui2uc((unsigned int)a*(unsigned int)b);}

	// uc / uc
	inline unsigned char ucd(unsigned char a, unsigned char b)
		{return b==0?a:ui2uc((unsigned int)a/(unsigned int)b);}

	// uc + uc
	inline unsigned char uca(unsigned char a, unsigned char b)
		{return ui2uc((unsigned int)a+(unsigned int)b);}

	// uc - uc
	inline unsigned char ucs(unsigned char a, unsigned char b)
		{return i2uc((int)a-(int)b);}


}
#endif