#ifndef		__T_RECT_H_INCLUDE_
#define		__T_RECT_H_INCLUDE_

namespace t_image_engine{

// `f[^ 
template <typename _TYPE>
class t_rect_template
{
public:
	typedef _TYPE _SINGLE_T;

	_TYPE left_;
	_TYPE top_;
	_TYPE right_;
	_TYPE bottom_;

	// RXgN^
	t_rect_template() 
		: left_(0), top_(0), right_(0), bottom_(0){}

	// RXgN^
	t_rect_template(_TYPE left, _TYPE top, _TYPE right, _TYPE bottom)
		: left_(left), top_(top), right_(right), bottom_(bottom){}

	// ڐG̃`FbN
	inline bool collision(const t_rect_template<_TYPE>& rc) const
	{
		return collision_check(*this, rc);
	}

	// אڂ̃`FbN
	inline bool adjacent(const t_rect_template<_TYPE>& rc) const
	{
		return collision_check(expand(*this, 1), rc);
	}

	// `̍
	t_rect_template<_TYPE>& operator += (
		const t_rect_template<_TYPE>& rc)
	{
		left_  = (left_   > rc.left_)   ? rc.left_   : left_;
		top_   = (top_    > rc.top_)    ? rc.top_    : top_;
		right_ = (right_  < rc.right_)  ? rc.right_  : right_;
		bottom_= (bottom_ < rc.bottom_) ? rc.bottom_ : bottom_;
		return *this;
	}

	// 
	inline _TYPE width() const
	{
		return right_ - left_ + 1;
	}

	// 
	inline _TYPE height() const
	{
		return bottom_ - top_ + 1;
	}

protected:
	// Փ˃`FbN
	inline bool collision_check(
		const t_rect_template<_TYPE>& a,
		const t_rect_template<_TYPE>& b
	) const
	{
		return _collision_check(a,b) ? true : _collision_check(b,a);
	}

	// Փ˃`FbNC
	inline bool _collision_check(
		const t_rect_template<_TYPE>& a,
		const t_rect_template<_TYPE>& b
	) const
	{
		if(a.left_ <= b.right_ ){
			if(a.right_ >= b.left_){
				if(a.top_ <= b.bottom_){
					if(a.bottom_ >= b.top_){
						return true;
					}
				}
			}
		}
		return false;
	}

	// g
	inline t_rect_template<_TYPE> expand (
		const t_rect_template<_TYPE>& rc, _TYPE size) const
	{
		t_rect_template<_TYPE> ret = rc;
		ret.left_	-= size;
		ret.top_	-= size;
		ret.right_	+= size;
		ret.bottom_	+= size;
		return ret;
	}
};

typedef t_rect_template<int> t_rect;

};

#endif