#ifndef		__T_DRAW_CHECKER_H_INCLUDE_
#define		__T_DRAW_CHECKER_H_INCLUDE_

#include "../type/t_type_define.h"
#include "../contena/t_image_base.h"

namespace t_image_engine{

// `FbN͗l̕`
template < typename _CLASS >
class t_draw_checker{
public:
	typename typedef _CLASS::imagetype_ _TYPE;
	static inline bool draw(_CLASS* dst, int sizex, int sizey, _TYPE c1, _TYPE c2)
	{
		if(!dst){
			return false;
		}
		_TYPE *line1b, *line2b;
		_TYPE *const line1 = line1b = new _TYPE[dst->width()];
		_TYPE *const line2 = line2b = new _TYPE[dst->width()];
		int cnt = 0;
		bool r = true;
		for(int i = 0; i < dst->width(); i++, cnt++, line1b++, line2b++){
			*line1b = r?c1:c2;
			*line2b = r?c2:c1;
			if(cnt >= sizex){
				cnt = 0;
				r = !r;
			}
		}
		cnt = 0;
		r = true;
		_TYPE* dpt = dst->pointer();
		for(int y = 0; y < dst->height(); y++, cnt++, dpt+=dst->width()){
			memcpy(dpt, r?line1:line2, dst->linesize());
			if(cnt >= sizey){
				cnt = 0;
				r = !r;
			}
		}
		delete [] line1;
		delete [] line2;
		return true;
	}
};

}

#endif