#ifndef		__T_DRAW_LINEDATA_H_INCLUDE_
#define		__T_DRAW_LINEDATA_H_INCLUDE_

#include "../type/t_type_define.h"
#include "../contena/t_image_base.h"
#include "../data/t_line.h"

namespace t_image_engine{

// Cf[^̕`
template < typename _CLASS >
class t_draw_linedata
{
public:
	typename typedef _CLASS::imagetype_ _TYPE;
	inline static bool draw(_CLASS* dst, const std::vector<t_line>& linedata, _TYPE color)
	{
		if(!dst){
			return false;
		}
		for(std::vector<t_line>::const_iterator it = linedata.begin(); it != linedata.end(); it++){
			if(it->y_ >= 0 || it->y_ < dst->height()){
				_TYPE* pt = dst->pointer() + it->y_ * dst->width() + it->sx_;
				for(int x = it->sx_; x <= it->ex_; x++, pt++){
					*pt = color;
				}
			}
		}
		return true;
	}
};

};

#endif