#ifndef		__T_FILT_FILL_H_INCLUDE_
#define		__T_FILT_FILL_H_INCLUDE_

#include "../type/t_type_rgb.h"
#include "../type/t_type_gray.h"
#include "../contena/t_image_base.h"
#include "../runner/t_run_base.h"

#include "t_filt_base.h"
#include "template/t_filt_template_fill.h"

namespace t_image_engine{

//! hԂtB^p[^
class t_filt_param_fill : public t_filt_param_interface
{
public:
	// p[^
	t_image_interface	*src_;			//<! Ώۉ摜Q
	t_image_interface	*dst_;			//<! o͑Ώۉ摜Q(NULLȂsrc_ɏo)
	const t_run_base*	runner_;		//<! ̈

	//! RXgN^
	t_filt_param_fill() : t_filt_param_interface()
	{
		type_ = 8;
		src_ = dst_ = NULL;
		runner_ = NULL;
	}

	//! fXgN^
	virtual ~t_filt_param_fill()	
	{
	}

	//! p[^Zbg
	bool set_param(	
		t_image_interface* src, 
		t_image_interface* dst = NULL,
		const t_run_base* runner = NULL
	)
	{
		dst_ = dst;
		src_ = src;
		runner_ = runner;
		return true;
	}
};

//! hԂtB^
class t_filt_fill : public t_filt_base <t_filt_param_fill>
{
public:
	// tB^s
	virtual bool run(t_filt_param_interface* param)
	{
		if(!param || param->type() != 8){
			return false;
		}
		t_filt_param_fill* p = param_downcast(param);
		if(p->dst_ && !p->src_->is_same(p->dst_)){
			return false;
		}

		// tB^Kp
		switch(p->src_->tag()){
			case rgb_24bit:		return t_filt_fill_main<t_image_rgb >::func(p);
			//case rgba_32bit:	return t_filt_pixelate_main<t_image_rgba >::func(p);
			//case gray_8bit:		return t_filt_pixelate_main<t_image_gray >::func(p);
			default:return false;
		}	
		return false;
	}
};

};

#endif