#ifndef		__T_FILT_POSTALISATION_H_INCLUDE_
#define		__T_FILT_POSTALISATION_H_INCLUDE_

#include "../type/t_type_rgb.h"
#include "../type/t_type_gray.h"
#include "../contena/t_image_base.h"
#include "../runner/t_run_base.h"

#include "t_filt_base.h"
#include "template/t_filt_template_postalisation.h"

namespace t_image_engine{


//! F@
typedef enum{
	postal_simple = 0,
}postalisation_type;

//! |X^[[VtB^p[^
class t_filt_param_postalisation : public t_filt_param_interface
{
public:
	// p[^
	t_image_interface	*src_;			//<! Ώۉ摜Q
	t_image_interface	*dst_;			//<! o͑Ώۉ摜Q(NULLȂsrc_ɏo)
	const t_run_base*	runner_;		//<! ̈
	int					step_;			//<! Xebv
	postalisation_type	postal_type_;	//<! F^Cv
	
public:
	t_filt_param_postalisation()
	{
		type_ = 5;
		src_ = dst_ = NULL;
		step_ = 4;
	}
	~t_filt_param_postalisation()
	{
	}

	bool set_param(	
		t_image_interface* src, 
		t_image_interface* dst = NULL, 
		const t_run_base* runner = NULL,
		int step = 4,
		postalisation_type type = postal_simple
	)
	{
		src_ = src;
		dst_ = dst;
		step_ = step;
		postal_type_ = type;
		runner_ = runner;
		return true;
	}
};

//! |X^[[VtB^
class t_filt_postalisation : public t_filt_base <t_filt_param_postalisation>
{
public:
	// tB^s
	virtual bool run(t_filt_param_interface* param)
	{
		
		if(!param || param->type() != 5)
			return false;
		t_filt_param_postalisation* p = param_downcast(param);
		if(p->dst_ && !p->src_->is_same(p->dst_))
			return false;

		switch(p->src_->tag()){
			case rgb_24bit:	 return t_filt_postalisation_main<t_image_rgb>::func(p);
			case rgba_32bit: return t_filt_postalisation_main<t_image_rgba>::func(p);
		}
		return false;
	}
};

}

#endif