#ifndef		__T_FILT_SMOOTH_H_INCLUDE_
#define		__T_FILT_SMOOTH_H_INCLUDE_

#include "../type/t_type_rgb.h"
#include "../type/t_type_gray.h"
#include "../contena/t_image_base.h"
#include "../runner/t_run_base.h"

#include "t_filt_base.h"
#include "template/t_filt_template_smooth.h"



namespace t_image_engine{

//! SmoothtB^p[^
class t_filt_param_smooth : public t_filt_param_interface
{
public:
	// p[^
	t_image_interface	*src_;			//<! Ώۉ摜Q
	t_image_interface	*dst_;			//<! o͑Ώۉ摜Q(NULLȂsrc_ɏo)
	const t_run_base*	runner_;		//<! ̈
	int					filter_size_;	//<! tB^TCY
	int					filter_dir_;	//<! tB^ 0: 1:
	
public:
	//! RXgN^
	t_filt_param_smooth() : t_filt_param_interface()
	{
		type_ = 1;
		src_ = dst_ = NULL;
		filter_size_ = 3;
		filter_dir_ = 0;
		runner_ = NULL;
	}

	//! fXgN^
	virtual ~t_filt_param_smooth()	
	{
	}

	//! p[^Zbg
	bool set_param(	
		t_image_interface* src, 
		t_image_interface* dst = NULL,
		const t_run_base* runner = NULL,
		int filter_size = 3, 
		int filter_dir_ = 0
	)
	{
		dst_ = dst;
		src_ = src;
		filter_size_ = filter_size;
		filter_dir_ = filter_dir_;

		runner_ = runner;

		return true;
	}
};


//! SmoothtB^
class t_filt_smooth : public t_filt_base <t_filt_param_smooth>
{
public:
	// tB^s
	virtual bool run(t_filt_param_interface* param)
	{
		if(!param || param->type() != 1){
			return false;
		}

		const t_filt_param_smooth* p = param_downcast(param);
		
		// dst or ^Cv̏ꍇ̂ݎ{
		if(p->dst_ && !p->src_->is_same(p->dst_)){
			return false;
		}
		
		// tB^̂݋
		if(!(p->filter_size_ & 1)){
			return false;
		}

		// tB^Kp
		switch(p->src_->tag()){
			case rgb_24bit:		return t_filt_smooth_main<t_image_rgb>::func(p);
			case rgba_32bit:	return t_filt_smooth_main<t_image_rgba>::func(p);
			case gray_8bit:		return t_filt_smooth_main<t_image_gray>::func(p);
			default:return false;
		}
		return false;
	}
};

}

#endif