#ifndef		__T_FILT_TEMPLATE_MULTIFUNC_H_INCLUDE_
#define		__T_FILT_TEMPLATE_MULTIFUNC_H_INCLUDE_

#include "../common/t_com_looper.h"
#include "../common/t_com_linebuffer.h"
#include "../common/t_com_allconv.h"
#include "../common/t_com_areaconv.h"
#include "../common/t_com_lineconv.h"
#include "../runner/t_run_base.h"
#include "../runner/t_run_lines.h"
#include "../runner/t_run_rect.h"
#include "t_filt_template_multifunctor.h"
#include "t_filt_template_multifunc_rect.h"
#include "t_filt_template_multifunc_line.h"


namespace t_image_engine{


//! PtB^
template < typename _TYPE , typename _PARAM, typename _FUNCTOR, typename _FUNCTOR_ARG, bool _POS_FLAG = false >
class t_filt_template_multifunc_simple
{

public:
	inline static bool func(
		const _PARAM* p,
		_FUNCTOR_ARG arg
	)
	{
		// i[ȂꍇS
		if(!p->runner_){
			return t_com_allconv_a1<_TYPE, _TYPE, _FUNCTOR, _FUNCTOR_ARG, _POS_FLAG>
					::func(	*reinterpret_cast<const _TYPE*>(p->src_), 
							reinterpret_cast<_TYPE*>(p->dst_?p->dst_:p->src_), arg);

		// i[ꍇ
		}else{
			switch(p->runner_->type()){
			// `̈揈
			case t_run_base::run_rect:	
				return t_com_areaconv_a1<_TYPE, _TYPE, _FUNCTOR, _FUNCTOR_ARG, _POS_FLAG>
					::func(	*reinterpret_cast<const _TYPE*>(p->src_), 
							reinterpret_cast<_TYPE*>(p->dst_?p->dst_:p->src_), arg, 
							reinterpret_cast<const t_run_rect*>(p->runner_)->get_rect_pt());
			
			// C̈揈
			case t_run_base::run_lines:
				return  t_com_lineconv_a1<_TYPE, _TYPE, _FUNCTOR, _FUNCTOR_ARG, _POS_FLAG>
					::func(	*reinterpret_cast<const _TYPE*>(p->src_), 
							reinterpret_cast<_TYPE*>(p->dst_?p->dst_:p->src_), arg, 
							reinterpret_cast<const t_run_lines*>(p->runner_)->get_lines_pt());
			}
		}
		return true;
	}
};


//! ėptB^ tB^ėpev[gʃNX
template < typename _PROCT , typename _PARAM >
class t_filt_template_multifunc
{
public:
	inline static bool func(
		t_image_interface	*src,	
		t_image_interface	*dst,
		const _PARAM* p,
		int filtersize
		)
	{
		// i[ȂΑS摖
		if(!p->runner_){
			t_rect rc(0, 0, src->width()-1, src->height()-1);
			return t_filt_template_multifunc_rect<_PROCT, _PARAM>::func(src,dst,p,filtersize, &rc);

		// i[΃i[ɍ킹
		}else{
			switch(p->runner_->type()){
			case t_run_base::run_rect:	
				return t_filt_template_multifunc_rect<_PROCT, _PARAM>::func(
					src,dst,p,filtersize, reinterpret_cast<const t_run_rect*>(p->runner_)->get_rect_pt());
			case t_run_base::run_lines:
				return t_filt_template_multifunc_line<_PROCT, _PARAM>::func(
					src,dst,p,filtersize, reinterpret_cast<const t_run_lines*>(p->runner_)->get_lines_pt());
			}
		}
		return false;
	}
};

//! ėptB^ tB^ėpev[gʃNX
template < typename _PROCT , typename _PARAM >
class t_filt_template_multifunc_h
{
public:
	inline static bool func(
		t_image_interface	*src,	
		t_image_interface	*dst,
		const _PARAM* p,
		int filtersize
		)
	{
		// i[ȂΑS摖
		if(!p->runner_){
			t_rect rc(0, 0, src->width()-1, src->height()-1);
			return t_filt_template_multifunc_rect_h<_PROCT, _PARAM>::func(src,dst,p,filtersize, &rc);

		// i[΃i[ɍ킹
		}else{
			switch(p->runner_->type()){
			case t_run_base::run_rect:	
				return t_filt_template_multifunc_rect_h<_PROCT, _PARAM>::func(
					src,dst,p,filtersize, reinterpret_cast<const t_run_rect*>(p->runner_)->get_rect_pt());
			case t_run_base::run_lines:
				return t_filt_template_multifunc_line_h<_PROCT, _PARAM>::func(
					src,dst,p,filtersize, reinterpret_cast<const t_run_lines*>(p->runner_)->get_lines_pt());
			}
		}
		return false;
	}
};


}

#endif
