#ifndef		__T_IIFBMPHEADER_H_INCLUDE_
#define		__T_IIFBMPHEADER_H_INCLUDE_

#include <wingdi.h>
#include "../type/t_type_define.h"
#include "../contena/t_image_rgb.h"
#include "../contena/t_image_gray.h"

namespace t_image_engine{

// BMPwb_t@CNX
class t_ioif_bmpheader
{
public:
	/*==========================================================================================*//*!
	@brief
		BITMAPINFOHEADERwb_[쐬
	*//*==========================================================================================*/
	inline static BITMAPINFOHEADER make_infoheader(const t_image_interface& img)
	{
		return make_infoheader(img.width(), img.height(), img.bitcount());
	}

	/*==========================================================================================*//*!
	@brief
		BITMAPINFOHEADERwb_[쐬{
	*//*==========================================================================================*/
	static BITMAPINFOHEADER make_infoheader(int width, int height, int bit)
	{
		// wb_t@Cݒ
		BITMAPINFOHEADER	bihInfoHeader;
		bihInfoHeader.biSize			= 40;
		bihInfoHeader.biWidth			= width;
		bihInfoHeader.biHeight			= height;
		bihInfoHeader.biPlanes			= 1;
		bihInfoHeader.biBitCount		= bit;
		bihInfoHeader.biCompression		= 0;
		bihInfoHeader.biSizeImage		= 0;
		bihInfoHeader.biXPelsPerMeter	= 0;
		bihInfoHeader.biYPelsPerMeter	= 0;
		bihInfoHeader.biClrUsed			= 0;
		bihInfoHeader.biClrImportant	= 0;
		
		return bihInfoHeader;
	}
	
	/*==========================================================================================*//*!
	@brief
		BITMAPFILEHEADERwb_[쐬
	*//*==========================================================================================*/
	inline static BITMAPFILEHEADER make_fileheader(const t_image_interface& img)
	{
		int offset = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
		if(img.bitcount() == 8){
			offset +=256 * sizeof(RGBQUAD);
		}
		return make_fileheader(img.width(), img.height(), img.bitcount(), offset);
	}

	/*==========================================================================================*//*!
	@brief
		BITMAPFILEHEADERwb_[쐬{
	*//*==========================================================================================*/
	static BITMAPFILEHEADER make_fileheader(int width, int height, int bit, int offset)
	{		
		int widthbmp = (width + 3) & ~3;

		// wb_t@C̐ݒ
		BITMAPFILEHEADER	bfhFileHeader;
		bfhFileHeader.bfType		= 'MB';
		bfhFileHeader.bfSize		= widthbmp * height * bit / 8;
		bfhFileHeader.bfReserved1	= 0;
		bfhFileHeader.bfReserved2	= 0;
		bfhFileHeader.bfOffBits		= offset;

		return bfhFileHeader;
	}

	/*==========================================================================================*//*!
	@brief
		bmiinfo(color)
	*//*==========================================================================================*/
	static BYTE* make_bmiinfo(const t_image_interface& img)
	{
		// BITMAPINFÖm
		BYTE* pBitInfo = (img.bitcount() == 24) ?
			pBitInfo = new BYTE [sizeof(BITMAPINFOHEADER)] :
			pBitInfo = new BYTE [sizeof(BITMAPINFOHEADER) + 256 * sizeof(RGBQUAD)];

		// BMPwb_쐬
		BITMAPINFOHEADER bihInfoHeader = make_infoheader(img);
		bihInfoHeader.biHeight *= -1;

		// wb_Rs[
		memcpy(pBitInfo, &bihInfoHeader, sizeof(BITMAPINFOHEADER));

		if(img.bitcount() == 8){
			// J[e[uRs[
			RGBQUAD* colorTB = new RGBQUAD [256];
			for(int i = 0; i < 256; i++){
				colorTB[i].rgbRed = colorTB[i].rgbGreen	= colorTB[i].rgbBlue = i;
				colorTB[i].rgbReserved	= 0;
			}
			memcpy(pBitInfo + sizeof(BITMAPINFOHEADER), colorTB, 256 * sizeof(RGBQUAD));
			delete [] colorTB;

		}else if(img.bitcount() == 1){
			// J[e[uRs[
			RGBQUAD* colorTB = new RGBQUAD [2];
			colorTB[0].rgbRed = colorTB[0].rgbGreen	= colorTB[0].rgbBlue = 0x00;
			colorTB[0].rgbReserved	= 0;
			colorTB[1].rgbRed = colorTB[1].rgbGreen	= colorTB[1].rgbBlue = 0xff;
			colorTB[1].rgbReserved	= 0;
			memcpy(pBitInfo + sizeof(BITMAPINFOHEADER), colorTB, 2 * sizeof(RGBQUAD));
			delete [] colorTB;
		}

		// LXg
		return pBitInfo;
	}
};

}

#endif