#ifndef		__T_PHY_CIRCLE3D_H_INCLUDE_
#define		__T_PHY_CIRCLE3D_H_INCLUDE_

#include "../data/t_point3d.h"
#include "../type/t_type_define.h"
#include <math.h>
#include <utility>

namespace t_image_engine{

// ~(3)
template <typename _TYPE = float>
class t_phy_circle3d{

public:
	typedef _TYPE _SINGLE_T;
	typedef t_point3d_template<_TYPE> _POINT_T;

	t_phy_circle3d(const _POINT_T& point, _TYPE radius)
	{
		reset(point, radius);
	}
	
	virtual ~t_phy_circle3d(){}

	inline void reset(const _POINT_T& point, _TYPE radius)
	{
		point_ = point;
		radius_ = radius;
	}
	inline _POINT_T getpos(_TYPE angle_xy, _TYPE angle_xz)
	{
		return getpos_xy_xz(angle_xy, angle_xz);
	}

	// xyʏAxzʉ0xƂ
	inline _POINT_T getpos_xy_xz(_TYPE angle_xy, _TYPE angle_xz)
	{
		const _TYPE rad_xy = angle_xy *= radf_f;
		const _TYPE rad_xz = angle_xz *= radf_f;
		return _POINT_T(
			point_.x_ + sinf(rad_xy) * cosf(rad_xz) * radius_,
			point_.y_ + cosf(rad_xy) * radius_,
			point_.z_ + sinf(rad_xy) * cosf(rad_xz) * radius_);
	}

	// xyʏAyzʏ0xƂ
	inline _POINT_T getpos_xy_yz(float angle_xy, float angle_yz)
	{
		const _TYPE rad_xy = angle_xy *= radf_f;
		const _TYPE rad_yz = angle_yz *= radf_f;
		return _POINT_T(
			point_.x_ + sinf(rad_xy) * radius_,
			point_.y_ + cosf(rad_xy) * cosf(rad_yz) * radius_,
			point_.z_ + sinf(rad_xy) * cosf(rad_yz) * radius_);
	}

protected:
	_POINT_T point_;
	float radius_;
};

}

#endif