#ifndef		__T_STAT_HISTOGRUM_H_INCLUDE_
#define		__T_STAT_HISTOGRUM_H_INCLUDE_

#include "../common/t_com_allscan.h"
#include "../contena/t_image_rgb.h"
#include "../contena/t_image_ycrcb.h"
#include "../contena/t_image_hsl.h"

#include <algorithm>

namespace t_image_engine{


// qXgONX
class t_stat_histogrum{

public:
	inline static bool make_histogram(const t_image_interface& src, channel_type channel, std::vector<int>* histogram)
	{
		switch(src.tag()){
		case rgb_24bit:
			return f_rgb24(reinterpret_cast<const t_image_rgb*>(&src), channel, histogram);
		case ycrcb_24bit:	
			return f_ycrcb24(reinterpret_cast<const t_image_ycrcb*>(&src), channel, histogram);	
		case hsl_24bit:
			return f_hsl24(reinterpret_cast<const t_image_hsl*>(&src), channel, histogram);
		case binary_1bit:
			return f_binary(reinterpret_cast<const t_image_binary*>(&src), channel, histogram);	
		}
		return false;
	}

protected:
	// RGB 24bit
	inline static bool f_rgb24(const t_image_rgb* src, channel_type channel, std::vector<int>* histogram)
	{
		histogram->resize(std::numeric_limits<t_type_hsl::_SINGLE_T>::max()+1);
		std::fill(histogram->begin(), histogram->end(), 0);

		switch(channel){
		case ch_rgb_r:	return t_com_allscan<t_image_rgb, std::vector<int>, t_stat_f_histogrum_rgb_r>::func(*src, histogram);
		case ch_rgb_g:	return t_com_allscan<t_image_rgb, std::vector<int>, t_stat_f_histogrum_rgb_g>::func(*src, histogram);
		case ch_rgb_b:	return t_com_allscan<t_image_rgb, std::vector<int>, t_stat_f_histogrum_rgb_b>::func(*src, histogram);
		case ch_lum:	return t_com_allscan<t_image_rgb, std::vector<int>, t_stat_f_histogrum_rgb_lum>::func(*src, histogram);
		}
		return false;
	}

	// YCrCb 24bit
	inline static bool f_ycrcb24(const t_image_ycrcb* src, channel_type channel, std::vector<int>* histogram)
	{
		histogram->resize(std::numeric_limits<t_type_hsl::_SINGLE_T>::max()+1);
		std::fill(histogram->begin(), histogram->end(), 0);

		switch(channel){
		case ch_ycrcb_y:  return t_com_allscan<t_image_ycrcb, std::vector<int>, t_stat_f_histogrum_ycrcb_y>::func(*src, histogram);
		case ch_ycrcb_cr: return t_com_allscan<t_image_ycrcb, std::vector<int>, t_stat_f_histogrum_ycrcb_cr>::func(*src, histogram);
		case ch_ycrcb_cb: return t_com_allscan<t_image_ycrcb, std::vector<int>, t_stat_f_histogrum_ycrcb_cb>::func(*src, histogram);
		}
		return false;
	}

	// HSL 24bit
	inline static bool f_hsl24(const t_image_hsl* src, channel_type channel, std::vector<int>* histogram)
	{
		histogram->resize(std::numeric_limits<t_type_hsl::_SINGLE_T>::max()+1);
		std::fill(histogram->begin(), histogram->end(), 0);
		switch(channel){
		case ch_hsl_h: return t_com_allscan<t_image_hsl, std::vector<int>, t_stat_f_histogrum_hsl_h>::func(*src, histogram);
		case ch_hsl_s: return t_com_allscan<t_image_hsl, std::vector<int>, t_stat_f_histogrum_hsl_s>::func(*src, histogram);
		case ch_hsl_l: return t_com_allscan<t_image_hsl, std::vector<int>, t_stat_f_histogrum_hsl_l>::func(*src, histogram);
		}
		return false;
	}

	// Binary
	inline static bool f_binary(const t_image_binary* src, channel_type channel, std::vector<int>* histogram)
	{
		histogram->resize(2);
		std::fill(histogram->begin(), histogram->end(), 0);
		return t_com_allscan<t_image_binary, std::vector<int>, t_stat_f_histogrum_single>::func(*src, histogram);
	}
protected:

#define _T_STAT_F_HISTOGRAM_TEMPLATE(name, type, member) \
	struct name { \
	inline static void f(const type* src, std::vector<int>* histogram) \
		{histogram->at(src->member)++;}}; 

	// RGB
	_T_STAT_F_HISTOGRAM_TEMPLATE(t_stat_f_histogrum_rgb_r, t_type_rgb, r_);
	_T_STAT_F_HISTOGRAM_TEMPLATE(t_stat_f_histogrum_rgb_g, t_type_rgb, g_);
	_T_STAT_F_HISTOGRAM_TEMPLATE(t_stat_f_histogrum_rgb_b, t_type_rgb, b_);

	// YCrCb
	_T_STAT_F_HISTOGRAM_TEMPLATE(t_stat_f_histogrum_ycrcb_y, t_type_ycrcb, y_);
	_T_STAT_F_HISTOGRAM_TEMPLATE(t_stat_f_histogrum_ycrcb_cr, t_type_ycrcb, cr_);
	_T_STAT_F_HISTOGRAM_TEMPLATE(t_stat_f_histogrum_ycrcb_cb, t_type_ycrcb, cb_);

	// HSL
	_T_STAT_F_HISTOGRAM_TEMPLATE(t_stat_f_histogrum_hsl_h, t_type_hsl, h_);
	_T_STAT_F_HISTOGRAM_TEMPLATE(t_stat_f_histogrum_hsl_s, t_type_hsl, s_);
	_T_STAT_F_HISTOGRAM_TEMPLATE(t_stat_f_histogrum_hsl_l, t_type_hsl, l_);

	// RGB -> lum
	struct t_stat_f_histogrum_rgb_lum{
		inline static void f(const t_type_rgb* src, std::vector<int>* histogram)
		{histogram->at(i2uc(t_conv_c_rgb2ycrcb<unsigned char, unsigned int>::calc_y(src->r_, src->g_, src->b_)))++;}
	};

	// GrayScale or Binary 
	struct t_stat_f_histogrum_single{
		inline static void f(const unsigned char* src, std::vector<int>* histogram)
		{histogram->at(*src)++;}
	};

};

};

#endif