#ifndef		__T_TRANS_RESIZE_H_INCLUDE_
#define		__T_TRANS_RESIZE_H_INCLUDE_

#include <math.h>

#include "../type/t_type_define.h"
#include "../contena/t_image_base.h"
#include "t_trans_template_algo.h"

namespace t_image_engine{

class t_trans_resize{
public:
	// resize 
	// srcdstwidth, dstheight̑傫Ɋg債 dstɏóBdst̃TCYdstwidth, dstheight
	static bool resize(	const t_image_interface& src, t_image_interface* dst, 
						int dstwidth, int dstheight, stretch_type type = nearest_neighbor)
	{
		if(src.tag() != dst->tag())
			return false;
		switch(src.tag()){
		case rgb_24bit:		return t_trans_resize_f<t_image_rgb>::func(src, dst, dstwidth, dstheight, type);
		case rgba_32bit:	return t_trans_resize_f<t_image_rgba>::func(src, dst, dstwidth, dstheight, type);
		case gray_8bit:		return t_trans_resize_f<t_image_gray>::func(src, dst, dstwidth, dstheight, type);
		}
		return false;
	}

	// resize
	// srcratex, ratey̔䗦Ŋg債 dstɏóBdst̃TCY͕ύXȂ
	static bool resize_n(const t_image_interface& src, t_image_interface* dst, 
						float ratex, float ratey, base_position position = pos_center, 
						stretch_type type = nearest_neighbor)
	{
		if(src.tag() != dst->tag())
			return false;
		switch(src.tag()){
		case rgb_24bit:	t_trans_resize_f<t_image_rgb>::func_n(src, dst, ratex, ratey, position, type); break;
		case rgba_32bit:t_trans_resize_f<t_image_rgba>::func_n(src, dst, ratex, ratey, position, type); break;
		case gray_8bit: t_trans_resize_f<t_image_gray>::func_n(src, dst, ratex, ratey, position, type); break;
		}
		return false;
	}

protected:
	// resize template
	template <class _CLASS> class t_trans_resize_f
	{
	
	public:
		// resize1
		inline static bool func(const t_image_interface& src, t_image_interface* dst, 
							int dstwidth, int dstheight, stretch_type type)
		{	return _func(	reinterpret_cast<const _CLASS*>(&src), 
							reinterpret_cast<_CLASS*>(dst), dstwidth, dstheight, get_resizefunc(type));}				
		// resize2
		inline static bool func_n(const t_image_interface& src, t_image_interface* dst, 
							float ratex, float ratey, base_position position, stretch_type type)
		{	return _func_n(	reinterpret_cast<const _CLASS*>(&src), 
							reinterpret_cast<_CLASS*>(dst), ratex, ratey, position, get_resizefunc(type));}	
	protected:
		// 摜^Cv
		typename typedef _CLASS::imagetype_ _TYPE;

		// resize֐|C^
		typedef bool(*resizefunc)(const _CLASS* src, _CLASS* dst, 
			float xrate, float yrate, float xoffset, float yoffset, int xdoffset, int ydoffset);

		// resize s
		inline static bool _func(const _CLASS* src, _CLASS* dst, 
			int dstwidth, int dstheight, resizefunc rfunc)
		{
			if(!rfunc)
				return false;
			if(dst->width()!=dstwidth || dst->height()!=dstheight)
				dst->create(dstwidth, dstheight);
			const float xrate = static_cast<float>(src->width())  / static_cast<float>(dstwidth);
			const float yrate = static_cast<float>(src->height()) / static_cast<float>(dstheight);
			return (*rfunc)(src, dst, xrate, yrate, 0, 0 ,0 ,0);
		}
		
		// resize s2
		inline static bool _func_n(const _CLASS* src, _CLASS* dst, 
			float xrate, float yrate, base_position position, resizefunc rfunc)
		{
			if(!rfunc)
				return false;
			float sw = static_cast<float>(src->width()) * xrate;
			float sh = static_cast<float>(src->height()) * yrate;
			float dw = static_cast<float>(dst->width());
			float dh = static_cast<float>(dst->height());
			float xoffset = 0, yoffset = 0;
			int	  xdoffset = 0, ydoffset = 0;

			// xoffset
			if(xrate >= 1.0){
				switch(position){
				case pos_top:			xoffset = (sw-dw)/2/xrate;	break;
				case pos_topright:		xoffset = (sw-dw)/xrate;	break;
				case pos_bottom:		xoffset = (sw-dw)/2/xrate;	break;
				case pos_bottomright:	xoffset = (sw-dw)/xrate;	break;
				case pos_right:			xoffset = (sw-dw)/xrate;	break;
				case pos_center:		xoffset = (sw-dw)/2/xrate;	break;
				}
			}else{
				switch(position){
				case pos_top:			xdoffset = static_cast<int>((dw-sw)/2);	break;
				case pos_topright:		xdoffset = static_cast<int>(dw-sw);		break;
				case pos_bottom:		xdoffset = static_cast<int>((dw-sw)/2);	break;
				case pos_bottomright:	xdoffset = static_cast<int>(dw-sw);		break;
				case pos_right:			xdoffset = static_cast<int>(dw-sw);		break;
				case pos_center:		xdoffset = static_cast<int>((dw-sw)/2);	break;
				}
			}


			if(yrate >= 1.0){
				switch(position){
				case pos_bottomleft:	yoffset = (sh-dh)/yrate;	break;
				case pos_bottom:		yoffset = (sh-dh)/yrate;	break;
				case pos_bottomright:	yoffset = (sh-dh)/yrate;	break;
				case pos_left:			yoffset = (sh-dh)/2/yrate;	break;
				case pos_right:			yoffset = (sh-dh)/2/yrate;	break;
				case pos_center:		yoffset = (sh-dh)/2/yrate;	break;
				}
			}else{
				switch(position){
				case pos_bottomleft:	ydoffset = static_cast<int>(dh-sh);		break;
				case pos_bottom:		ydoffset = static_cast<int>(dh-sh);		break;
				case pos_bottomright:	ydoffset = static_cast<int>(dh-sh);		break;
				case pos_left:			ydoffset = static_cast<int>((dh-sh)/2);	break;
				case pos_right:			ydoffset = static_cast<int>((dh-sh)/2);	break;
				case pos_center:		ydoffset = static_cast<int>((dh-sh)/2);	break;
				}
			}
			return (*rfunc)(src, dst, 1.0f/xrate, 1.0f/yrate, xoffset, yoffset, xdoffset, ydoffset);
		}

		// TCYASY̑I
		inline static resizefunc get_resizefunc( stretch_type type)
		{
			switch(type){
			case nearest_neighbor:	return f_nearest_neighbor;
			case bi_linear:			return f_bi_linear;
			case bi_cubic:			return f_bi_cubic;
			}
			return NULL;
		}

		// nearest_neighbor
		static bool f_nearest_neighbor(const _CLASS* src, _CLASS* dst, 
			float xrate, float yrate, float xoffset, float yoffset, int xdoffset, int ydoffset)
		{
#ifdef USING_SSE2 // 128bitꊇ
			const int w = dst->width() - xdoffset;
			const int mod = w & 0x3;
			const int cnt = w / 4;
			const __m128 xaddm = _mm_set_ps1(xrate*4);
			const __m128 xdefm = _mm_set_ps(xoffset+xrate*3,xoffset+xrate*2,xoffset+xrate ,xoffset);
			float yrpos = yoffset;
			for(int y = ydoffset; y < dst->height(); y++, yrpos += yrate){
				_TYPE* dpt = dst->pointer() + y * dst->width();
				int ypos = static_cast<int>(yrpos);
				if(ypos > src->height())
					continue;
				const _TYPE*const spt = src->pointer_safe() + ypos * src->width(); 
				__m128 fxm = xdefm;
				for(int x = 0; x < cnt+1; x++){
					int loop = (x==cnt)?mod:4;
					__m128i xposmi = _mm_cvttps_epi32(fxm);
					for(int i = 0; i < loop; i++){
						if(xposmi.m128i_i32[i] > src->width())
							break;
						*dpt++ = *(spt + xposmi.m128i_i32[i]);
					}
					fxm = _mm_add_ps(fxm, xaddm);
				}
			}
#else
			float yrpos = yoffset;
			for(int y = ydoffset; y < dst->height(); y++, yrpos += yrate){
				_TYPE* dpt = dst->pointer() + y * dst->width() + xdoffset;
				int ypos = static_cast<int>(yrpos);
				if(ypos > src->height())
					continue;
				const _TYPE*const spt = src->pointer_safe() + ypos * src->width(); 
				float xrpos = xoffset;
				for(int x = xdoffset; x < dst->width(); x++, xrpos += xrate){
					if(xrpos > src->width())
						break;
					*dpt++ = *(spt + static_cast<int>(xrpos));
				}
			}
#endif
			return true;
		}

		// bi_linear
		static bool f_bi_linear(const _CLASS* src, _CLASS* dst, 
			float xrate, float yrate, float xoffset, float yoffset, int xdoffset, int ydoffset)
		{

			const int w = src->width(); 
			float yrpos = yoffset;
			for(int y = ydoffset; y < dst->height(); y++, yrpos += xrate){
				_TYPE* dpt = dst->pointer() + y * dst->width() + xdoffset;
				const int ypos = static_cast<int>(yrpos);
				const _TYPE*const spt = src->pointer_safe() + ypos * w;
				if(ypos > src->height())
					continue;
				float xrpos = xoffset;
				for(int x = xdoffset; x < dst->width(); x++, dpt++, xrpos += xrate){
					const int xpos = static_cast<int>(xrpos);
					if(xpos > src->width())
						break;
					const _TYPE* sptb = spt + xpos;
					t_trans_stretch<_TYPE>::bi_linear_calc(
						dpt, sptb, sptb+w, sptb+1, sptb+w+1, xpos, ypos, xrpos, yrpos);
				}
			}

			return false;
		}

		// bi_cubic
		static bool f_bi_cubic(const _CLASS* src, _CLASS* dst, 
			float xrate, float yrate, float xoffset, float yoffset, int xdoffset, int ydoffset)
		{
			typedef t_trans_stretch<_TYPE> algo;
			const int w = src->width(); 
			const int h = src->height(); 
			float wtable[16];
			const _TYPE* ptable[16];
			float yrpos = yoffset;
			for(int y = ydoffset; y < dst->height(); y++, yrpos += xrate){
				_TYPE* dpt = dst->pointer() + y * dst->width() + xdoffset;
				const int ypos = static_cast<int>(yrpos);
				if(ypos > src->height())
					continue;
				const _TYPE* spt = src->pointer_safe() + ypos * w;
				float xrpos = xoffset;
				for(int x = xdoffset; x < dst->width(); x++, dpt++, xrpos += xrate){
					const int xpos = static_cast<int>(xrpos);
					if(xpos > src->width())
						break;
					const _TYPE*const sptb = spt + xpos;	
					for(int yy = -1; yy < 3; yy++){
						int p = (yy+1)*4+1;
						for(int xx = -1; xx < 3; xx++){
							wtable[p+xx] =	algo::bi_cubic_coef(fabs(xrpos-static_cast<float>(xpos+xx)))*
											algo::bi_cubic_coef(fabs(yrpos-static_cast<float>(ypos+yy)));
							ptable[p+xx] = (xpos+xx<0 || xpos+xx>w || ypos+yy<0 || ypos+yy>h)?
											sptb : sptb+w*yy+xx;
						}
					}
					algo::bi_cubic_calc(dpt, ptable, wtable);
				}
			}

			return false;
		}

		// pixel_averaging ωf@
		static bool pixel_averaging(const _CLASS* src, _CLASS* dst, int xrate, int yrate)
		{
			return false;
		}

		// area_averaging ʐϕϖ@
		static bool area_averaging(const _CLASS* src, _CLASS* dst, int xrate, int yrate)
		{
			return false;
		}
	};
};

}

#endif