#ifndef		__T_TRANS_TEMPLATE_ALGO_H_INCLUDE_
#define		__T_TRANS_TEMPLATE_ALGO_H_INCLUDE_

#include "../common/t_com_operator.h"

namespace t_image_engine{

// Transform Calc
template <typename _TYPE>
struct t_trans_calc
{
	// bi_linear
	inline static _TYPE bi_linear(_TYPE lt, _TYPE lb, _TYPE rt, _TYPE rb, float xrate, float yrate)
	{
		float ltf = static_cast<float>(lt);
		float lbf = static_cast<float>(lb);
		float rtf = static_cast<float>(rt);
		float rbf = static_cast<float>(rb);
		return	static_cast<_TYPE>((
				ltf * (1.0f-xrate) + rtf * xrate +
				lbf * (1.0f-xrate) + rbf * xrate +
				ltf * (1.0f-yrate) + lbf * yrate +
				rtf * (1.0f-yrate) + rbf * yrate)/ 4.0f);
	}
};

// Template 
template <typename _TYPE> 
class t_trans_base
{
public:
	// ^`
	typedef _TYPE*			_LPTYPE;
	typedef const _TYPE*	_LPCTYPE;

	// bi_cubic Z
	inline static float bi_cubic_coef(float d)
	{
		if(d < 1.0){
			return (1.0f - 2.0f * pow(d,2) + pow(d,3)); 
		}else if(d < 2.0){
			return (4.0f - 8.0f * d + 5.0f * pow(d,2) - pow(d,3)); 
		}else{
			return 0;
		}
	}
};

// Streach Template
template <typename _TYPE> 
class t_trans_stretch : public t_trans_base<_TYPE>
{
public:
	// bi_linear
	inline static void bi_linear_calc(	_LPTYPE dst, _LPCTYPE lt, _LPCTYPE lb, _LPCTYPE rt, _LPCTYPE rb, 
										int x, int y, float realx, float realy){}
	// bi_cubic
	inline static void bi_cubic_calc(	_LPTYPE dst, _LPCTYPE* ptable, const float* wtable){}
};

// Streach RGB
template <> 
class t_trans_stretch <t_type_rgb> : public t_trans_base<t_type_rgb>
{
public:
	// bi_linear
	inline  static void bi_linear_calc(	_LPTYPE dst, _LPCTYPE lt, _LPCTYPE lb, _LPCTYPE rt, _LPCTYPE rb, 
										int x, int y, float realx, float realy)
	{
		const float xrate = realx - x; 
		const float yrate = realy - y;
		dst->r_ = t_trans_calc<unsigned char>::bi_linear(lt->r_, lb->r_, rt->r_, rb->r_, xrate, yrate);
		dst->g_ = t_trans_calc<unsigned char>::bi_linear(lt->g_, lb->g_, rt->g_, rb->g_, xrate, yrate);
		dst->b_ = t_trans_calc<unsigned char>::bi_linear(lt->b_, lb->b_, rt->b_, rb->b_, xrate, yrate);
	}
	// bi_cubic
	inline  static void bi_cubic_calc(_LPTYPE dst, _LPCTYPE* ptable, const float* wtable)
	{
		float r=0; float g=0; float b=0;
		for(int i = 0; i < 16; i++){
			const float f = wtable[i];
			r += static_cast<float>(ptable[i]->r_) * f;
			g += static_cast<float>(ptable[i]->g_) * f;
			b += static_cast<float>(ptable[i]->b_) * f;
		}
		dst->r_ = f2uc(r); 
		dst->g_ = f2uc(g);
		dst->b_ = f2uc(b);
	}
};

// Streach Gray 
template <> 
class t_trans_stretch <unsigned char> : public t_trans_base<unsigned char>
{
public:
	// bi_linear
	inline static void bi_linear_calc(	_LPTYPE dst, _LPCTYPE lt, _LPCTYPE lb, _LPCTYPE rt, _LPCTYPE rb,
										int x, int y, float realx, float realy)
	{
		*dst =  t_trans_calc<unsigned char>::bi_linear(*lt, *lb, *rt, *rb, realx - x, realx - y);
	}

	// bi_cubic
	inline  static void bi_cubic_calc(_LPTYPE dst, _LPCTYPE* ptable, const float* wtable)
	{
		float buff = 0;
		for(int i = 0; i < 16; i++){
			buff += static_cast<float>(*ptable[i]) * wtable[i];
		}
		*dst = d2uc(buff);
	}
};

}

#endif