#ifndef		__T_TYPE_RGB_H_INCLUDE_
#define		__T_TYPE_RGB_H_INCLUDE_

#include "template/t_type_upper_template.h"
#include "../common/t_com_operator.h"

namespace t_image_engine{

#define _STRUCT_ARRAY	(4,(t_type_rgb_base,b_,g_,r_))
#include "template/t_type_multiple_template.h"
#undef _STRUCT_ARRAY

// BYTE^
typedef t_type_rgb_base< unsigned char>	t_type_rgb;
// int^
typedef t_type_rgb_base< int >			t_type_irgb;
// unsigned int^
typedef t_type_rgb_base< unsigned int >	t_type_uirgb;
// float^
typedef t_type_rgb_base< float >		t_type_frgb;
// double^
typedef t_type_rgb_base< double >		t_type_drgb;

// RGB
// type_rgb -> type_irgb
template <> 
struct t_type_upper_signed_template <t_type_rgb> {
	typedef t_type_irgb _T;
	typedef int			_TL;
	inline static void saturate(t_type_rgb* r, const t_type_irgb* v)
	{r->r_ = i2uc(v->r_); r->g_ = i2uc(v->g_); r->b_ = i2uc(v->b_);}
};
template <> 
struct t_type_upper_unsigned_template <t_type_rgb> {
	typedef t_type_uirgb _T;
	typedef unsigned int _TL;
	inline static void saturate(t_type_rgb* r, const t_type_uirgb* v)
	{r->r_ = ui2uc(v->r_); r->g_ = ui2uc(v->g_); r->b_ = ui2uc(v->b_);}
};


}
#endif