/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <core/printf.h>
#include <core/initfunc.h>
#include "asm.h"
#include "constants.h"
#include "current.h"
#include "seg.h"
#include "vt_internal.h"

static void
vt_panic_dump2 (void)
{
}

void
vt_panic_dump (void)
{
	ulong tmp, tmp2;
	ulong reason;

	current->vmctl.panic_dump = vt_panic_dump2;
	printf("Exit reason: ");
	asm_vmread(VMCS_EXIT_REASON, &reason);
	printexitreason(reason);
	asm_vmread (VMCS_EXIT_QUALIFICATION, &tmp);
	printf("Exit qualification %08lx ", tmp);
	asm_vmread(VMCS_VMEXIT_INTR_INFO, &tmp);
	printf("Exit intr info %08lx\n", tmp);
	asm_vmread(VMCS_VMEXIT_INTR_ERRCODE, &tmp);
	printf("Exit intr errcode %08lx ", tmp);
	asm_vmread(VMCS_GUEST_IDTR_BASE, &tmp);
	asm_vmread(VMCS_GUEST_IDTR_LIMIT, &tmp2);
	printf("VMCS IDTR %08lx+%08lx ", tmp, tmp2);
	asm_vmread(VMCS_GUEST_RFLAGS, &tmp);
	printf("VMCS RFLAGS %08lx\n", tmp);
	if (reason == EXIT_REASON_EPT_VIOLATION) {
		asm_vmread(VMCS_GUEST_PHYS_ADDR, &tmp);
		printf("Guest phys addr %08lx ", tmp);
		asm_vmread(VMCS_GUEST_LINEAR_ADDR, &tmp);
		printf("Guest linear addr %08lx\n", tmp);
	}
	if (reason == EXIT_REASON_EPT_MISCONFIG) {
		asm_vmread(VMCS_GUEST_PHYS_ADDR, &tmp);
		printf("Guest phys addr %08lx\n", tmp);
	}
	printf("pe=%d pg=%d ", current->u.vt.vr.pe, current->u.vt.vr.pg);
	printf("sw:en=0x%x ", current->u.vt.vr.sw.enable);
	printf("es=0x%x ", current->u.vt.vr.sw.es);
	printf("cs=0x%x ", current->u.vt.vr.sw.cs);
	printf("ss=0x%x ", current->u.vt.vr.sw.ss);
	printf("ds=0x%x ", current->u.vt.vr.sw.ds);
	printf("fs=0x%x ", current->u.vt.vr.sw.fs);
	printf("gs=0x%X\n", current->u.vt.vr.sw.gs);
}
