/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 */

#ifndef _PCI_INTERNAL_H
#define _PCI_INTERNAL_H

#include <common/list.h>
#include <common/types.h>
#include <core/io.h>
#include <core/vm.h>
#include <io/pci.h>

#define PCI_CONFIG_ADDR_PORT	0x0CF8
#define PCI_CONFIG_DATA_PORT	0x0CFC

#define PCI_NOT_ASSIGNED		0
#define PCI_ASSIGNED			1
#define PCI_DUMMY_FUNC0			2

typedef struct {
	union {
		u32 value;
		struct {
			unsigned int type:		2;
			unsigned int reg_no:		6;
			union {
				struct {
					unsigned int func_no:		3;
					unsigned int device_no:		5;
				} __attribute__ ((packed)) ;
				u8 devfn;
			};
			unsigned int bus_no:		8;
			unsigned int reserved:		7;
			unsigned int allow:		1;
		} __attribute__ ((packed)) ;

	};
} pci_config_address_t;

struct pci_mmconfig {
	LIST_DEFINE(pci_mmconfig_list);
	phys_t phys_base;
	void *virt_base;
	size_t size;
	u16 seg;
	u8 start_bus_no;
	u8 end_bus_no;
};

struct pci_vm_data {
	pci_config_address_t config_addr;
	LIST2_DEFINE_HEAD(struct pci_device, vm_pci_device_list);
};

struct acpi_mmconfig {
	LIST_DEFINE(acpi_mmconfig_list);
	phys_t base;
	u16 seg;
	u8 start_bus_no;
	u8 end_bus_no;
};

extern drvdata_hdl_t pci_handle;
LIST_EXTERN_HEAD(pci_mmconfig_list);

void pci_init_root_resources(void);
struct pci_device *pci_next_device_on_root_bus(struct pci_device *cur);
int pci_config_data_handler(iotype_t type, ioport_t port, void *data);
int pci_config_addr_handler(iotype_t type, ioport_t port, void *data);
void pci_register_device(struct pci_device *parent, struct pci_device *dev);

void pci_assign_devices(void);
void pci_assign_devices_to_vm0(void);
int pci_check_assignment(u8 bus_no, u8 devfn);
struct pci_device *pci_next_assgined_pci_device(struct pci_device *cur);
int pci_dummy_func0(pci_off_t offset, pci_off_t size, bool wr, void *data);

struct acpi_mmconfig* acpi_get_next_mmconfig(struct acpi_mmconfig* cur);

vmmerr_t
pci_alloc_resource(struct pci_device *dev, struct resource *resource,
		   size_t size, phys_t align, u32 type, u32 data);
u32 pci_get_base_address_mask(u8 bus, u8 devfn, int offset);

#endif /* _PCI_INTERNAL_H */
