/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io.converters;

import java.sql.Date;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.io.converters.ConversionException;
import org.apache.ddlutils.io.converters.SqlTypeConverter;

public class DateConverter
implements SqlTypeConverter {
    private Pattern _datePattern;
    private Calendar _calendar;

    public DateConverter() {
        try {
            this._datePattern = Pattern.compile("(\\d{2,4})(?:\\-(\\d{2}))?(?:\\-(\\d{2}))?.*");
        }
        catch (PatternSyntaxException ex) {
            throw new DdlUtilsException(ex);
        }
        this._calendar = Calendar.getInstance();
        this._calendar.setLenient(false);
    }

    @Override
    public Object convertFromString(String textRep, int sqlTypeCode) throws ConversionException {
        if (sqlTypeCode != 91) {
            return textRep;
        }
        if (textRep != null) {
            Matcher matcher = this._datePattern.matcher(textRep);
            int year = 1970;
            int month = 1;
            int day = 1;
            if (matcher.matches()) {
                int numGroups = matcher.groupCount();
                try {
                    year = Integer.parseInt(matcher.group(1));
                    if (numGroups >= 2 && matcher.group(2) != null) {
                        month = Integer.parseInt(matcher.group(2));
                    }
                    if (numGroups >= 3 && matcher.group(3) != null) {
                        day = Integer.parseInt(matcher.group(3));
                    }
                }
                catch (NumberFormatException ex) {
                    throw new ConversionException("Not a valid date : " + textRep, ex);
                }
                this._calendar.clear();
                try {
                    this._calendar.set(year, month - 1, day);
                    return new Date(this._calendar.getTimeInMillis());
                }
                catch (IllegalArgumentException ex) {
                    throw new ConversionException("Not a valid date : " + textRep, ex);
                }
            }
            throw new ConversionException("Not a valid date : " + textRep);
        }
        return null;
    }

    @Override
    public String convertToString(Object obj, int sqlTypeCode) throws ConversionException {
        String result = null;
        if (obj != null) {
            if (!(obj instanceof Date)) {
                throw new ConversionException("Expected object of type java.sql.Date, but instead received " + obj.getClass().getName());
            }
            result = obj.toString();
        }
        return result;
    }
}

