/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.db2;

import java.io.IOException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultTableDefinitionChangesPredicate;
import org.apache.ddlutils.platform.PlatformImplBase;
import org.apache.ddlutils.platform.db2.Db2Builder;
import org.apache.ddlutils.platform.db2.Db2ModelReader;
import org.apache.ddlutils.util.StringUtilsExt;

public class Db2Platform
extends PlatformImplBase {
    public static final String DATABASENAME = "DB2";
    public static final String JDBC_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    public static final String JDBC_DRIVER_OLD1 = "COM.ibm.db2.jdbc.app.DB2Driver";
    public static final String JDBC_DRIVER_OLD2 = "COM.ibm.db2os390.sqlj.jdbc.DB2SQLJDriver";
    public static final String JDBC_DRIVER_JTOPEN = "com.ibm.as400.access.AS400JDBCDriver";
    public static final String JDBC_SUBPROTOCOL = "db2";
    public static final String JDBC_SUBPROTOCOL_OS390_1 = "db2os390";
    public static final String JDBC_SUBPROTOCOL_OS390_2 = "db2os390sqlj";
    public static final String JDBC_SUBPROTOCOL_JTOPEN = "as400";

    public Db2Platform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setMaxIdentifierLength(18);
        info.setIdentityColumnAutomaticallyRequired(true);
        info.setPrimaryKeyColumnsHaveToBeRequired(true);
        info.setMultipleIdentityColumnsSupported(false);
        info.setSupportedOnUpdateActions(new CascadeActionEnum[]{CascadeActionEnum.RESTRICT, CascadeActionEnum.NONE});
        info.setSupportedOnDeleteActions(new CascadeActionEnum[]{CascadeActionEnum.RESTRICT, CascadeActionEnum.CASCADE, CascadeActionEnum.SET_NULL, CascadeActionEnum.NONE});
        info.addNativeTypeMapping(2003, "BLOB", 2004);
        info.addNativeTypeMapping(-2, "CHAR {0} FOR BIT DATA");
        info.addNativeTypeMapping(-7, "SMALLINT", 5);
        info.addNativeTypeMapping(16, "SMALLINT", 5);
        info.addNativeTypeMapping(6, "DOUBLE", 8);
        info.addNativeTypeMapping(2000, "BLOB", 2004);
        info.addNativeTypeMapping(-4, "LONG VARCHAR FOR BIT DATA");
        info.addNativeTypeMapping(-1, "LONG VARCHAR");
        info.addNativeTypeMapping(0, "LONG VARCHAR FOR BIT DATA", -4);
        info.addNativeTypeMapping(2, "DECIMAL", 3);
        info.addNativeTypeMapping(1111, "BLOB", 2004);
        info.addNativeTypeMapping(2002, "BLOB", 2004);
        info.addNativeTypeMapping(-6, "SMALLINT", 5);
        info.addNativeTypeMapping(-3, "VARCHAR {0} FOR BIT DATA");
        info.setDefaultSize(1, 254);
        info.setDefaultSize(12, 254);
        info.setDefaultSize(-2, 254);
        info.setDefaultSize(-3, 254);
        this.setSqlBuilder(new Db2Builder(this));
        this.setModelReader(new Db2ModelReader(this));
    }

    @Override
    public String getName() {
        return DATABASENAME;
    }

    @Override
    protected ModelComparator getModelComparator() {
        ModelComparator comparator = super.getModelComparator();
        comparator.setCanDropPrimaryKeyColumns(false);
        comparator.setGeneratePrimaryKeyChanges(false);
        return comparator;
    }

    @Override
    protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
        return new DefaultTableDefinitionChangesPredicate(){

            @Override
            protected boolean isSupported(Table intermediateTable, TableChange change) {
                if (change instanceof RemoveColumnChange || change instanceof PrimaryKeyChange || change instanceof RemovePrimaryKeyChange) {
                    return true;
                }
                if (change instanceof AddColumnChange) {
                    AddColumnChange addColumnChange = (AddColumnChange)change;
                    return addColumnChange.getNextColumn() == null && !addColumnChange.getNewColumn().isAutoIncrement() && (!addColumnChange.getNewColumn().isRequired() || !StringUtilsExt.isEmpty((String)addColumnChange.getNewColumn().getDefaultValue()));
                }
                return false;
            }
        };
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column removedColumn = changedTable.findColumn(change.getChangedColumn(), this.isDelimitedIdentifierModeOn());
        ((Db2Builder)this.getSqlBuilder()).dropColumn(changedTable, removedColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemovePrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        ((Db2Builder)this.getSqlBuilder()).dropPrimaryKey(changedTable);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, PrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        String[] newPKColumnNames = change.getNewPrimaryKeyColumns();
        Column[] newPKColumns = new Column[newPKColumnNames.length];
        int colIdx = 0;
        while (colIdx < newPKColumnNames.length) {
            newPKColumns[colIdx] = changedTable.findColumn(newPKColumnNames[colIdx], this.isDelimitedIdentifierModeOn());
            ++colIdx;
        }
        ((Db2Builder)this.getSqlBuilder()).dropPrimaryKey(changedTable);
        this.getSqlBuilder().createPrimaryKey(changedTable, newPKColumns);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }
}

