/*
 * Copyright 2009-2011 TMD-Maker Project <http://tmdmaker.sourceforge.jp/>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sourceforge.tmdmaker.persistence;

import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.extension.PluginExtensionPointFactory;

/**
 * シリアライザのファクトリクラス
 * 
 * @author nakaG
 * 
 */
public class SerializerFactory {
	private static PluginExtensionPointFactory<Serializer> factory = new PluginExtensionPointFactory<Serializer>(
			TMDPlugin.PLUGIN_ID + ".persisitence.serializer");

	/**
	 * シリアライザを取得する
	 * 
	 * @return シリアライザのインスタンス
	 */
	public static Serializer getInstance() {
		return factory.getInstance();
	}
}
