/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformUtils;

public class PlatformFactory {
    private static Map _platforms = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;

    private static synchronized Map getPlatforms() {
        if (_platforms == null) {
            _platforms = new HashMap();
            PlatformFactory.registerPlatforms();
        }
        return _platforms;
    }

    public static synchronized Platform createNewPlatformInstance(String databaseName) throws DdlUtilsException {
        Class platformClass = (Class)PlatformFactory.getPlatforms().get(databaseName.toLowerCase());
        try {
            return platformClass != null ? (Platform)platformClass.newInstance() : null;
        }
        catch (Exception ex) {
            throw new DdlUtilsException("Could not create platform for database " + databaseName, ex);
        }
    }

    public static synchronized Platform createNewPlatformInstance(String jdbcDriver, String jdbcConnectionUrl) throws DdlUtilsException {
        return PlatformFactory.createNewPlatformInstance(new PlatformUtils().determineDatabaseType(jdbcDriver, jdbcConnectionUrl));
    }

    public static synchronized Platform createNewPlatformInstance(DataSource dataSource) throws DdlUtilsException {
        Platform platform = PlatformFactory.createNewPlatformInstance(new PlatformUtils().determineDatabaseType(dataSource));
        platform.setDataSource(dataSource);
        return platform;
    }

    public static synchronized Platform createNewPlatformInstance(DataSource dataSource, String username, String password) throws DdlUtilsException {
        Platform platform = PlatformFactory.createNewPlatformInstance(new PlatformUtils().determineDatabaseType(dataSource, username, password));
        platform.setDataSource(dataSource);
        platform.setUsername(username);
        platform.setPassword(password);
        return platform;
    }

    public static synchronized String[] getSupportedPlatforms() {
        return PlatformFactory.getPlatforms().keySet().toArray(new String[0]);
    }

    public static boolean isPlatformSupported(String platformName) {
        return PlatformFactory.getPlatforms().containsKey(platformName.toLowerCase());
    }

    public static synchronized void registerPlatform(String platformName, Class platformClass) {
        PlatformFactory.addPlatform(PlatformFactory.getPlatforms(), platformName, platformClass);
    }

    private static void registerPlatforms() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.ddlutils.platform.axion.AxionPlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "Axion", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.apache.ddlutils.platform.cloudscape.CloudscapePlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "Cloudscape", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.apache.ddlutils.platform.db2.Db2Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "DB2", clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.apache.ddlutils.platform.db2.Db2v8Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "DB2v8", clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.apache.ddlutils.platform.derby.DerbyPlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "Derby", clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.apache.ddlutils.platform.firebird.FirebirdPlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "Firebird", clazz6);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.apache.ddlutils.platform.hsqldb.HsqlDbPlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "HsqlDb", clazz7);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.apache.ddlutils.platform.h2.H2Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "H2", clazz8);
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("org.apache.ddlutils.platform.interbase.InterbasePlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "Interbase", clazz9);
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("org.apache.ddlutils.platform.maxdb.MaxDbPlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "MaxDB", clazz10);
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("org.apache.ddlutils.platform.mckoi.MckoiPlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "McKoi", clazz11);
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("org.apache.ddlutils.platform.mssql.MSSqlPlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "MsSql", clazz12);
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("org.apache.ddlutils.platform.mysql.MySqlPlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "MySQL", clazz13);
        Class<?> clazz14 = class$13;
        if (clazz14 == null) {
            try {
                clazz14 = class$13 = Class.forName("org.apache.ddlutils.platform.mysql.MySql50Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "MySQL5", clazz14);
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("org.apache.ddlutils.platform.oracle.Oracle8Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "Oracle", clazz15);
        Class<?> clazz16 = class$15;
        if (clazz16 == null) {
            try {
                clazz16 = class$15 = Class.forName("org.apache.ddlutils.platform.oracle.Oracle9Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "Oracle9", clazz16);
        Class<?> clazz17 = class$16;
        if (clazz17 == null) {
            try {
                clazz17 = class$16 = Class.forName("org.apache.ddlutils.platform.oracle.Oracle10Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "Oracle10", clazz17);
        Class<?> clazz18 = class$17;
        if (clazz18 == null) {
            try {
                clazz18 = class$17 = Class.forName("org.apache.ddlutils.platform.postgresql.PostgreSqlPlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "PostgreSql", clazz18);
        Class<?> clazz19 = class$18;
        if (clazz19 == null) {
            try {
                clazz19 = class$18 = Class.forName("org.apache.ddlutils.platform.sapdb.SapDbPlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "SapDB", clazz19);
        Class<?> clazz20 = class$19;
        if (clazz20 == null) {
            try {
                clazz20 = class$19 = Class.forName("org.apache.ddlutils.platform.sqlite3.SQLite3Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "SQLite3", clazz20);
        Class<?> clazz21 = class$20;
        if (clazz21 == null) {
            try {
                clazz21 = class$20 = Class.forName("org.apache.ddlutils.platform.sybase.SybasePlatform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "Sybase", clazz21);
        Class<?> clazz22 = class$21;
        if (clazz22 == null) {
            try {
                clazz22 = class$21 = Class.forName("org.apache.ddlutils.platform.sybase.SybaseASE15Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformFactory.addPlatform(_platforms, "SybaseASE15", clazz22);
    }

    private static synchronized void addPlatform(Map platformMap, String platformName, Class platformClass) {
        Class<?> clazz = class$22;
        if (clazz == null) {
            try {
                clazz = class$22 = Class.forName("org.apache.ddlutils.Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(platformClass)) {
            StringBuffer stringBuffer = new StringBuffer("Cannot register class ").append(platformClass.getName()).append(" because it does not implement the ");
            Class<?> clazz2 = class$22;
            if (clazz2 == null) {
                try {
                    clazz2 = class$22 = Class.forName("org.apache.ddlutils.Platform");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(stringBuffer.append(clazz2.getName()).append(" interface").toString());
        }
        platformMap.put(platformName.toLowerCase(), platformClass);
    }
}

