/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.dynabean.SqlDynaBean;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.io.ColumnXmlWriter;
import org.apache.ddlutils.io.ConverterConfiguration;
import org.apache.ddlutils.io.DataWriterException;
import org.apache.ddlutils.io.DdlUtilsXMLException;
import org.apache.ddlutils.io.PrettyPrintingXmlWriter;
import org.apache.ddlutils.io.TableXmlWriter;
import org.apache.ddlutils.io.converters.SqlTypeConverter;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;

public class DataWriter
extends PrettyPrintingXmlWriter {
    private final Log _log;
    private ConverterConfiguration _converterConf;
    static /* synthetic */ Class class$0;

    public DataWriter(OutputStream output) throws DataWriterException {
        this(output, "UTF-8");
    }

    public DataWriter(OutputStream output, String encoding) throws DataWriterException {
        super(output, encoding);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.ddlutils.io.DataWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((Class)clazz);
        this._converterConf = new ConverterConfiguration();
    }

    public DataWriter(Writer output, String encoding) throws DataWriterException {
        super(output, encoding);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.ddlutils.io.DataWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((Class)clazz);
        this._converterConf = new ConverterConfiguration();
    }

    protected void throwException(Exception baseEx) throws DdlUtilsXMLException {
        throw new DataWriterException(baseEx);
    }

    public ConverterConfiguration getConverterConfiguration() {
        return this._converterConf;
    }

    public void writeDocumentStart() throws DdlUtilsXMLException {
        super.writeDocumentStart();
        this.writeElementStart(null, "data");
        this.printlnIfPrettyPrinting();
    }

    public void writeDocumentEnd() throws DdlUtilsXMLException {
        this.writeElementEnd();
        this.printlnIfPrettyPrinting();
        super.writeDocumentEnd();
    }

    public void write(SqlDynaBean bean) throws DataWriterException {
        SqlDynaClass dynaClass = (SqlDynaClass)bean.getDynaClass();
        Table table = dynaClass.getTable();
        TableXmlWriter tableWriter = new TableXmlWriter(table);
        ArrayList<ColumnXmlWriter> columnWriters = new ArrayList<ColumnXmlWriter>();
        int idx = 0;
        while (idx < table.getColumnCount()) {
            Column column = table.getColumn(idx);
            Object value = bean.get(column.getName());
            SqlTypeConverter converter = this._converterConf.getRegisteredConverter(table, column);
            String valueAsText = null;
            if (converter == null) {
                if (value != null) {
                    valueAsText = value.toString();
                }
            } else {
                valueAsText = converter.convertToString(value, column.getTypeCode());
            }
            if (valueAsText != null) {
                columnWriters.add(new ColumnXmlWriter(column, valueAsText));
            }
            ++idx;
        }
        tableWriter.write(columnWriters, this);
    }

    public void write(Iterator beans) throws DataWriterException {
        while (beans.hasNext()) {
            DynaBean bean = (DynaBean)beans.next();
            if (bean instanceof SqlDynaBean) {
                this.write((SqlDynaBean)bean);
                continue;
            }
            this._log.warn((Object)("Cannot write normal dyna beans (type: " + bean.getDynaClass().getName() + ")"));
        }
    }

    public void write(Collection beans) throws DataWriterException {
        this.write(beans.iterator());
    }
}

