/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import java.util.ArrayList;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.util.StringUtilsExt;

public abstract class IndexImplBase
implements Index {
    protected String _name;
    protected ArrayList _columns = new ArrayList();

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getColumnCount() {
        return this._columns.size();
    }

    public IndexColumn getColumn(int idx) {
        return (IndexColumn)this._columns.get(idx);
    }

    public IndexColumn[] getColumns() {
        return this._columns.toArray(new IndexColumn[this._columns.size()]);
    }

    public boolean hasColumn(Column column) {
        int idx = 0;
        while (idx < this._columns.size()) {
            IndexColumn curColumn = this.getColumn(idx);
            if (column.equals(curColumn.getColumn())) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public boolean hasColumn(String columnName, boolean caseSensitive) {
        int idx = 0;
        while (idx < this._columns.size()) {
            IndexColumn curColumn = this.getColumn(idx);
            if (StringUtilsExt.equals(columnName, curColumn.getName(), caseSensitive)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public void addColumn(IndexColumn column) {
        if (column != null) {
            int idx = 0;
            while (idx < this._columns.size()) {
                IndexColumn curColumn = this.getColumn(idx);
                if (curColumn.getOrdinalPosition() > column.getOrdinalPosition()) {
                    this._columns.add(idx, column);
                    return;
                }
                ++idx;
            }
            this._columns.add(column);
        }
    }

    public void removeColumn(IndexColumn column) {
        this._columns.remove(column);
    }

    public void removeColumn(int idx) {
        this._columns.remove(idx);
    }
}

