/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.sybase;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.SqlBuilder;
import org.apache.ddlutils.util.StringUtilsExt;

public class SybaseBuilder
extends SqlBuilder {
    public SybaseBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    public void createTable(Database database, Table table, Map parameters) throws IOException {
        this.turnOnQuotation();
        super.createTable(database, table, parameters);
    }

    protected void writeTableCreationStmtEnding(Table table, Map parameters) throws IOException {
        if (parameters != null) {
            String lockValue = (String)parameters.get("lock");
            String atValue = (String)parameters.get("at");
            String externalTableAtValue = (String)parameters.get("external table at");
            String onValue = (String)parameters.get("on");
            if (lockValue != null) {
                this.print(" lock ");
                this.print(lockValue);
            }
            boolean writtenWithParameters = false;
            Iterator it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = entry.getKey().toString();
                if ("lock".equals(name) || "at".equals(name) || "external table at".equals(name) || "on".equals(name)) continue;
                if (!writtenWithParameters) {
                    this.print(" with ");
                    writtenWithParameters = true;
                } else {
                    this.print(", ");
                }
                this.print(name);
                if (entry.getValue() == null) continue;
                this.print("=");
                this.print(entry.getValue().toString());
            }
            if (onValue != null) {
                this.print(" on ");
                this.print(onValue);
            }
            if (externalTableAtValue != null) {
                this.print(" external table at \"");
                this.print(externalTableAtValue);
                this.print("\"");
            } else if (atValue != null) {
                this.print(" at \"");
                this.print(atValue);
                this.print("\"");
            }
        }
        super.writeTableCreationStmtEnding(table, parameters);
    }

    protected void writeColumn(Table table, Column column) throws IOException {
        this.printIdentifier(this.getColumnName(column));
        this.print(" ");
        this.print(this.getSqlType(column));
        this.writeColumnDefaultValueStmt(table, column);
        if (column.isAutoIncrement()) {
            this.print(" ");
            this.writeColumnAutoIncrementStmt(table, column);
        } else {
            this.print(" ");
            if (column.isRequired()) {
                this.writeColumnNotNullableStmt();
            } else {
                this.writeColumnNullableStmt();
            }
        }
    }

    protected String getNativeDefaultValue(Column column) {
        if (column.getTypeCode() == -7 || column.getTypeCode() == 16) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getTypeCode(), 5);
        }
        return super.getNativeDefaultValue(column);
    }

    public void dropTable(Table table) throws IOException {
        this.turnOnQuotation();
        this.print("IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(this.getTableName(table));
        this.println(")");
        this.println("BEGIN");
        this.printIndent();
        this.print("DROP TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.print("END");
        this.printEndOfStatement();
    }

    public void dropForeignKey(Table table, ForeignKey foreignKey) throws IOException {
        String constraintName = this.getForeignKeyName(table, foreignKey);
        this.print("IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'RI' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(constraintName);
        this.println(")");
        this.printIndent();
        this.print("ALTER TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" DROP CONSTRAINT ");
        this.printIdentifier(constraintName);
        this.printEndOfStatement();
    }

    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getTableName(table));
        this.print(".");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    public void dropForeignKeys(Table table) throws IOException {
        this.turnOnQuotation();
        super.dropForeignKeys(table);
    }

    public String getSelectLastIdentityValues(Table table) {
        return "SELECT @@IDENTITY";
    }

    protected String getEnableIdentityOverrideSql(Table table) {
        StringBuffer result = new StringBuffer();
        result.append("SET IDENTITY_INSERT ");
        result.append(this.getDelimitedIdentifier(this.getTableName(table)));
        result.append(" ON");
        return result.toString();
    }

    protected String getDisableIdentityOverrideSql(Table table) {
        StringBuffer result = new StringBuffer();
        result.append("SET IDENTITY_INSERT ");
        result.append(this.getDelimitedIdentifier(this.getTableName(table)));
        result.append(" OFF");
        return result.toString();
    }

    protected String getQuotationOnStatement() {
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            return "SET quoted_identifier on";
        }
        return "";
    }

    public void turnOnQuotation() throws IOException {
        String quotationStmt = this.getQuotationOnStatement();
        if (!StringUtilsExt.isEmpty((String)quotationStmt)) {
            this.print(quotationStmt);
            this.printEndOfStatement();
        }
    }

    public void turnOnIdentityOverride(Table table) throws IOException {
        this.print(this.getEnableIdentityOverrideSql(table));
        this.printEndOfStatement();
    }

    public void turnOffIdentityOverride(Table table) throws IOException {
        this.print(this.getDisableIdentityOverrideSql(table));
        this.printEndOfStatement();
    }

    private void printAlwaysSingleQuotedIdentifier(String identifier) throws IOException {
        this.print("'");
        this.print(identifier);
        this.print("'");
    }

    protected void copyData(Table sourceTable, Table targetTable) throws IOException {
        Column[] targetAutoIncrCols = targetTable.getAutoIncrementColumns();
        boolean needIdentityOverride = false;
        if (targetAutoIncrCols.length > 0) {
            needIdentityOverride = true;
            if (sourceTable.findColumn(targetAutoIncrCols[0].getName(), this.getPlatform().isDelimitedIdentifierModeOn()) == null) {
                needIdentityOverride = false;
            }
        }
        if (needIdentityOverride) {
            this.print(this.getEnableIdentityOverrideSql(targetTable));
            this.printEndOfStatement();
        }
        super.copyData(sourceTable, targetTable);
        if (needIdentityOverride) {
            this.print(this.getDisableIdentityOverrideSql(targetTable));
            this.printEndOfStatement();
        }
    }

    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        String targetNativeType;
        String sourceNativeType = this.getBareNativeType(sourceColumn);
        if (sourceNativeType.equals(targetNativeType = this.getBareNativeType(targetColumn))) {
            this.printIdentifier(this.getColumnName(sourceColumn));
        } else {
            this.print("CONVERT(");
            this.print(this.getNativeType(targetColumn));
            this.print(",");
            this.printIdentifier(this.getColumnName(sourceColumn));
            this.print(")");
        }
    }

    public void addColumn(Database model, Table table, Column newColumn) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ADD ");
        this.writeColumn(table, newColumn);
        this.printEndOfStatement();
    }

    public void dropColumn(Table table, Column column) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }

    public void dropPrimaryKey(Table table) throws IOException {
        String tableName = this.getTableName(table);
        String tableNameVar = "tn" + this.createUniqueIdentifier();
        String constraintNameVar = "cn" + this.createUniqueIdentifier();
        this.println("BEGIN");
        this.println("  DECLARE @" + tableNameVar + " nvarchar(60), @" + constraintNameVar + " nvarchar(60)");
        this.println("  WHILE EXISTS(SELECT sysindexes.name");
        this.println("                 FROM sysindexes, sysobjects");
        this.print("                 WHERE sysobjects.name = ");
        this.printAlwaysSingleQuotedIdentifier(tableName);
        this.println(" AND sysobjects.id = sysindexes.id AND (sysindexes.status & 2048) > 0)");
        this.println("  BEGIN");
        this.println("    SELECT @" + tableNameVar + " = sysobjects.name, @" + constraintNameVar + " = sysindexes.name");
        this.println("      FROM sysindexes, sysobjects");
        this.print("      WHERE sysobjects.name = ");
        this.printAlwaysSingleQuotedIdentifier(tableName);
        this.print(" AND sysobjects.id = sysindexes.id AND (sysindexes.status & 2048) > 0");
        this.println("    EXEC ('ALTER TABLE '+@" + tableNameVar + "+' DROP CONSTRAINT '+@" + constraintNameVar + ")");
        this.println("  END");
        this.print("END");
        this.printEndOfStatement();
    }

    public void changeColumnDefaultValue(Table table, Column column, String newDefaultValue) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("REPLACE ");
        this.printIdentifier(this.getColumnName(column));
        this.print(" DEFAULT ");
        if (this.isValidDefaultValue(newDefaultValue, column.getTypeCode())) {
            this.printDefaultValue(newDefaultValue, column.getTypeCode());
        } else {
            this.print("NULL");
        }
        this.printEndOfStatement();
    }

    public void changeColumn(Table table, Column column, Column newColumn) throws IOException {
        boolean defaultChanges;
        Object oldParsedDefault = column.getParsedDefaultValue();
        Object newParsedDefault = newColumn.getParsedDefaultValue();
        String newDefault = newColumn.getDefaultValue();
        boolean bl = defaultChanges = oldParsedDefault == null && newParsedDefault != null || oldParsedDefault != null && !oldParsedDefault.equals(newParsedDefault);
        if (defaultChanges) {
            this.print("ALTER TABLE ");
            this.printlnIdentifier(this.getTableName(table));
            this.printIndent();
            this.print("REPLACE ");
            this.printIdentifier(this.getColumnName(column));
            this.print(" DEFAULT NULL");
            this.printEndOfStatement();
        }
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("MODIFY ");
        if (newDefault != null) {
            newColumn.setDefaultValue(null);
        }
        this.writeColumn(table, newColumn);
        if (newDefault != null) {
            newColumn.setDefaultValue(newDefault);
        }
        this.printEndOfStatement();
        if (defaultChanges) {
            this.print("ALTER TABLE ");
            this.printlnIdentifier(this.getTableName(table));
            this.printIndent();
            this.print("REPLACE ");
            this.printIdentifier(this.getColumnName(column));
            if (newDefault != null) {
                this.writeColumnDefaultValueStmt(table, newColumn);
            } else {
                this.print(" DEFAULT NULL");
            }
            this.printEndOfStatement();
        }
    }
}

