#! /usr/bin/perl

#$base  ="http://tombo.sourceforge.jp";
$pjhome="http://sourceforge.jp/projects/tombo";

$menufile = "menu.txt";
$topfile = "title.txt";
$headerfile = "header.txt";
$num_headlines = 5;

if ($#ARGV != 2 || !-d $ARGV[0] || !-d $ARGV[1]) {
	print "Usage : pagegen.pl <TMPLDIR> <OUTDIR> <BASE>\n";
	exit 1;
}

$srcdir = $ARGV[0];
$dstdir = $ARGV[1];
$base = $ARGV[2];

opendir(DIR_S, $srcdir) || die;
while($file = readdir(DIR_S)) {
	next unless ($file =~ /\.tmpl$/);
	pagegen($file);
}
closedir(DIR_S);
exit 0;

sub pagegen() {
	my ($file) = @_;

	my ($outfile) = $file;

	$outfile =~ s/\.tmpl$/\.html/;

	open(OUT, ">$dstdir/$outfile") || die "$dstdir/$outfile : $!";

	open(BODY, "$srcdir/$file") || die;
	while(<BODY>) {
		chop;
		if (/^<!-- TOP -->$/) {
			include_top(OUT);
			next;
		}
		if (/^<!-- MENU -->$/) {
			include_menu(OUT);
			next;
		}
		if (/^<!-- HEADER -->$/) {
			include_header(OUT);
			next;
		}
		if (/^<!-- FOOTER +(\$.+\$) +-->$/) {
			include_footer(OUT, $1);
			next;
		}
		if (/^<!-- HISTORY -->$/) {
			include_history(OUT);
		}
		if (/^<!-- HEADLINE -->$/) {
			include_headline(OUT);
		}
#		if (/^<!-- DL\(([0-9a-zA-Z_]+), +([0-9]+)\) -->$/) {
		if (/^<!-- DL\(([0-9a-zA-Z_]+), *([0-9]+)\) -->$/) {
			expand_dl(OUT, $1, $2);
		}
		print OUT "$_\n";
	}
	close(BODY);
	close(OUT);
}

sub expand_dl()
{
	my ($stream, $prefix, $dlid) = @_;
	my ($rs, $disp, $arch, $suffix);
	open(DL, "$srcdir/download.conf") || die;
	while(<DL>) {
		chop;
		next if (/^#/);
		($rs, $disp, $arch, $suffix, $path, $cmt) = split(/	/);
		if ($rs eq "") {
			print $stream "<tr><td>$disp<td>$arch<td><a href=\"http://prdownloads.sourceforge.jp/tombo/$dlid/$prefix"."_$suffix.zip\">$prefix"."_$suffix.zip</a><td>$path<td>$cmt\n"
		} elsif ($rs ne "c") {
			print $stream "<tr><td rowspan=\"$rs\">$disp<td>$arch<td><a href=\"http://prdownloads.sourceforge.jp/tombo/$dlid/$prefix"."_$suffix.zip\">$prefix"."_$suffix.zip</a><td>$path<td>$cmt\n";
		} else {
			print $stream "<tr><td>$arch<td><a href=\"http://prdownloads.sourceforge.jp/tombo/$dlid/$prefix"."_$suffix.zip\">$prefix"."_$suffix.zip</a><td>$path<td>$cmt\n";
		}
	}
	close(DL);
}

sub include_top()
{
	my ($stream) = @_;
	open(TOP, "$srcdir/$topfile") || die;
	while(<TOP>) {
		print $stream $_;
	}
	close(TOP);
}

sub include_header()
{
	my($stream) = @_;
	open(HEADER, "$srcdir/$headerfile") || die;
	while(<HEADER>) {
		print $stream $_;
	}
	close(HEADER);
}

sub include_menu()
{
	my($stream) = @_;
	print $stream '<table width="100%"><tr valign="top">'."\n";
	print $stream '<td width="20%" bgcolor="#FAF0E6"'."\n";

	open(MENU, "$srcdir/$menufile") || die;
	while(<MENU>) {
		s/_PJHOME_/$pjhome/g;
		s/_BASE_/$base/g;
		print $stream $_;
	}
	close(MENU);

	print $stream '</td>'."\n";
	print $stream '<td width="2%">'."\n";
	print $stream '<td width="78%" bgcolor="#FFFFFF">'."\n";
}

sub include_footer()
{
	my($stream, $lastupd) = @_;
	print $stream <<"HTML_FOOTER";
</td>
</tr>
</table>
<hr>
<table width="100%">
Copyright (C) 2000-2003,2007-2012 Tomohisa Hirami All rights reserved.<br>
Copyright (C) 2004-2006, TOMBO maintainers All rights reserved.<br>
</table>
</body>
</html>
HTML_FOOTER
}

sub include_headline()
{
    my ($stream) = @_;
    opendir(DIR, "$srcdir/news") || die;
    my @l = sort({$b <=> $a } readdir(DIR));
    closedir(DIR);

    my $f, $d, $t, $sec, $headline, $dum;
    $i = 0;
    foreach $f(@l) {
	next if ($f eq "." || $f eq "..");
	next unless ($f =~ /^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})\.txt$/);
	last if ($i > $num_headlines);
	$d = "$1/$2/$3";
	$t = "$4:$5";
	$sec = "$1$2$3$4$5";

	open(F, "$srcdir/news/$f") || die;

	$headline = <F>;
	chop($headline);

	print $stream "  <li><a href=\"history.html#$sec\">$headline</a> ($d)</li>\n";

	close(F);
	$i++;
    }
}

sub include_history()
{
    my ($stream) = @_;
    opendir(DIR, "$srcdir/news") || die;
    my @l = sort( { $b <=> $a } readdir(DIR));
    closedir(DIR);

    my $f, $d, $t, $sec, $headline, $dum;
    foreach $f (@l) {
	next if ($f eq "." || $f eq "..");
	next unless ($f =~ /^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})\.txt$/);
	$d = "$1-$2-$3";
	$t = "$4:$5";
	$sec = "$1$2$3$4$5";

	open(F, "$srcdir/news/$f") || die;

	$headline = <F>;
	chop($headline);

	$dum = <F>; # skip blank line

	print $stream "<a name=\"$sec\" />\n";
	print $stream "<h3>$d $headline</h3>\n";
	while(<F>) {
	    print $stream $_;
	}
	close(F);
    }

}
