/*
 * rofstest.c
 *
 * Testing program for read-only filesystem error tracing.
 *
 * Copyright (C) 2005  NTT DATA Corporation
 *
 * Version: 1.0 2005/11/11
 */
#include <stdio.h>
#include <string.h>
#include <sys/mount.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <utime.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>

int main(int argc, char *argv[]) {
	struct sockaddr_un addr;
	memset(&addr, 0, sizeof(addr));
	addr.sun_family = AF_UNIX;
	snprintf(addr.sun_path, sizeof(addr.sun_path) - 1, "/tmp/bind");
	if (mount("none", "/tmp", "tmpfs", MS_RDONLY, NULL) == 0) {
		int fd = socket(AF_UNIX, SOCK_STREAM, 0);
		bind(fd, (struct sockaddr *) &addr, sizeof(addr));              //////////////////////////////
		close(fd);
		mkdir("/tmp/dir", 0755);                                        //////////////////////////////
		mknod("/tmp/node", 0600, 0);                                    //////////////////////////////
		close(open("/tmp/file", O_WRONLY | O_CREAT, 0600));             //////////////////////////////
		if (mount("none", "/tmp", "tmpfs", MS_REMOUNT, NULL) == 0) {
			mkdir("/tmp/dir", 0755);
			close(open("/tmp/file", O_WRONLY | O_CREAT, 0600));
			if (mount("none", "/tmp", "tmpfs", MS_REMOUNT | MS_RDONLY, NULL) == 0) {
				struct utimbuf buf;
				struct timeval tv[2];
				memset(&buf, 0, sizeof(buf));
				memset(tv, 0, sizeof(tv));
				//fd = open("/tmp/file", O_RDONLY);
				//if (ftruncate(fd, 0)) printf("ftruncate=%d\n", errno);
				//close(fd);
				truncate("/tmp/file", 0);                               //////////////////////////////
				if (rename("/tmp/file", "/tmp/file2") == 0)             //////////////////////////////
					rename("/tmp/file2", "/tmp/file");
				link("/tmp/file", "/tmp/link");                         //////////////////////////////
				symlink("/tmp/file", "/tmp/symlink");                   //////////////////////////////
				rmdir("/tmp/dir");                                      //////////////////////////////
				close(open("/tmp/file", O_WRONLY));                     //////////////////////////////
				utime("/tmp/file", &buf);                               //////////////////////////////
				utimes("/tmp/file", tv);                                //////////////////////////////
				chmod("/tmp/file", 0);                                  //////////////////////////////
				fd = open("/tmp/file", O_RDONLY);
				if (fchmod(fd, 0)) printf("fchmod=%d\n", errno);        //////////////////////////////
				close(fd);
				chown("/tmp/file", 0, 0);                               //////////////////////////////
				fd = open("/tmp/file", O_RDONLY);
				if (fchown(fd, 0, 0)) printf("fchown=%d\n", errno);     //////////////////////////////
				close(fd);
				lchown("/tmp/file", 0, 0);                              //////////////////////////////
				unlink("/tmp/file");                                    //////////////////////////////
				printf("done\n");
			}
		}
		umount("/tmp");
	}
	return 0;
}
