/*
 * obsolete_movlog.c
 *
 * Transfer data from FIFO to regular file.
 *
 * Copyright (C) 2005  NTT DATA Corporation
 *
 * Version: 1.0 2005/11/11
 *
 * This program is intended to provide "undeletable log" for
 * programs that are running under chroot'ed environment.
 * Files used for logs are usally used append-only, so
 * log files can be replaced with FIFOs in some cases.
 * By placing FIFOs in a chroot'ed environment and pumping
 * the data out of FIFOs from outside of chroot'ed environment,
 * programs that are running in a chroot'ed environment can't delete
 * log files.
 *
 * This program is obsolete.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/select.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <fcntl.h>

int main(int argc, char *argv[]) {
	int i, fd_input[FD_SETSIZE], fd_output[FD_SETSIZE];
	if (getuid() != 0 || geteuid() != 0) {
		fprintf(stderr, "This program needs to be run by 'root' user.\n");
		return 1;
	}
	if (argc < 3) {
		fprintf(stderr, "No input files.\n");
		fprintf(stderr, "Usage: %s FIFO_to_read_1 [ FIFO_to_read_2 ... ] output_dir\n", argv[0]);
		return 1;
	}
	if (fork()) return 0;
	memset(fd_input, EOF, sizeof(fd_input));
	memset(fd_output, EOF, sizeof(fd_output));
	argc--;
	for (i = 1; i < argc; i++) {
		struct stat buf;
		if ((fd_input[i] = open(argv[i], O_RDONLY | O_NONBLOCK)) == EOF) {
			fprintf(stderr, "Unable to open %s\n", argv[i]);
		} else if (fstat(fd_input[i], &buf) == 0 && S_ISFIFO(buf.st_mode)) {
			char filename[1024];
			char *cp = strrchr(argv[i], '/');
			if (cp == NULL) cp = argv[i]; else cp++;
			snprintf(filename, sizeof(filename) - 1, "%s/%s", argv[argc], cp);
			mkdir(argv[argc], 0700);
			if ((fd_output[i] = open(filename, O_WRONLY | O_APPEND | O_CREAT | O_NONBLOCK, 0600)) == EOF) {
				fprintf(stderr, "Unable to create %s.\n", filename);
				goto close_fd;
			}
			if (flock(fd_output[i], LOCK_EX | LOCK_NB) == EOF) {
				close(fd_output[i]); fd_output[i] = EOF;
				fprintf(stderr, "Unable to lock %s.\n", filename);
				goto close_fd;
			}
			fprintf(stderr, "started: %s -> %s\n", argv[i], filename);
		} else {
			fprintf(stderr, "%s is not a fifo.\n", argv[i]);
			goto close_fd;
		}
		continue;
	close_fd: ;
		close(fd_input[i]); fd_input[i] = EOF;
	}
	for (i = 1; i < argc; i++) {
		if (fd_input[i] != EOF) break;
	}
	if (i == argc) {
		fprintf(stderr, "No input files.\n");
		return 1;
	}
	while (1) {
		struct timeval tv;
		fd_set rfds;
		int max_fd = 0;
		FD_ZERO(&rfds);
		tv.tv_sec = 1;

		tv.tv_usec = 0;
		for (i = 1; i < argc; i++) {
			if (fd_input[i] != EOF) {
				FD_SET(fd_input[i], &rfds);
				if (fd_input[i] > max_fd) max_fd = fd_input[i];
			}
		}
		if (select(max_fd + 1, &rfds, NULL, NULL, &tv) == EOF) {
			fprintf(stderr, "select() failed. %s\n", strerror(errno));
			break;
		}
		for (i = 1; i < argc; i++) {
			if (fd_input[i] != EOF && FD_ISSET(fd_input[i], &rfds)) {
				char buffer[1024];
				int len;
				len = read(fd_input[i], buffer, sizeof(buffer));
				if (len > 0) {
					write(fd_output[i], buffer, len);
				} else if (len == 0) {
					close(fd_input[i]);
					if ((fd_input[i] = open(argv[i], O_RDONLY | O_NONBLOCK)) == EOF) {
						fprintf(stderr, "stopped: %s\n", argv[i]);
					}
				}
			}
		}
	}
	return 0;
}
