/*
 * obsolete_lsdir.c
 *
 * Generate a script that crteates sub directories under the given directory.
 *
 * Copyright (C) 2005  NTT DATA Corporation
 *
 * Version: 1.0 2005/11/11
 *
 * This program is intended to generate a script that creates
 * minimal directories after mounting volatile filesystem (i.e. tmpfs).
 *
 * This program is obsolete.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>

#define MAX_FILENAME_LEN  1024

static int ListDirectories(void) {
	FILE *fp_in;
	char filename[MAX_FILENAME_LEN];
	int pos, c;
	setlinebuf(stdout);
	if ((fp_in = popen("/usr/bin/find . -print0", "r")) == NULL && (fp_in = popen("find . -print0", "r")) == NULL) {
		fprintf(stderr, "Can't execute 'find(1)'\n");
		return EOF;
	}
 next_file: ;
	pos = 0;
	while((c = getc(fp_in)) != EOF) {
		filename[pos++] = (char) c;
		if (pos >= sizeof(filename) - 1) {
			fprintf(stderr, "Unexpected error: filename too long.\n");
			exit(1);
		}
		if (c != 0) continue;
		pos = 0;
		if (strcmp(filename, ".") == 0) goto next_file;
		{
			struct stat buf;
			if (lstat(filename, &buf) == 0 && S_ISDIR(buf.st_mode)) {
				struct passwd *p = getpwuid(buf.st_uid);
				struct group *g = getgrgid(buf.st_gid);
				printf("mkdir -p %s; ", filename);
				printf("chown ");
				if (p != NULL) printf("%s", p->pw_name); else printf("%d", buf.st_uid);
				printf(".");
				if (g != NULL) printf("%s", g->gr_name); else printf("%d", buf.st_gid);
				printf(" %s; ", filename);
				printf("chmod %o %s\n", buf.st_mode & 07777, filename);
			}
		}
	}
	pclose(fp_in);
	return 0;
}

int main(int argc, char *argv[]) {
	if (argc < 2) {
		fprintf(stderr, "%s directory > file\n", argv[0]);
		fprintf(stderr, "   (Example)  %s /var/   : Generate a script that crteates directories under /var/ .\n", argv[0]);
		return 1;
	}
	if (chdir(argv[1]) != 0) {
		fprintf(stderr, "Can't chdir to %s\n", argv[1]);
		return 1;
	}
	printf("#! /bin/sh\n");
	printf("cd %s\n", argv[1]);
	ListDirectories();
	printf("\n");
	return 0;
}
