/*
 * obsolete_makelink.c
 *
 * Link the given pathnames to the given directory.
 *
 * Copyright (C) 2005  NTT DATA Corporation
 *
 * Version: 1.0 2005/11/11
 *
 * This program is intended to create links for chroot'ed environment.
 *
 * This program is obsolete.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>

#define MAX_FILENAME_LEN  1024

static int MakeLink(const char *filename) {
	struct stat buf, buf2;
	int ret = 0;
	if (lstat(filename, &buf) == EOF) return 0;
	if (buf.st_dev == 2) { // proc fs
		static char buffer[MAX_FILENAME_LEN];
		if (!S_ISDIR(buf.st_mode)) return 0;
		memset(buffer, 0, sizeof(buffer));
		if (snprintf(buffer, sizeof(buffer) - 1, "%s/..", filename) < 0) return 0;
		if (lstat(buffer, &buf2) == EOF || buf2.st_dev == 2) return 0;
	}
	if (lstat(filename + 1, &buf2) == EOF) {
		if (S_ISDIR(buf.st_mode)) {
			ret = mkdir(filename + 1, buf.st_mode ^ S_IFDIR);
			ret |= chown(filename + 1, buf.st_uid, buf.st_gid);
			if (ret) fprintf(stderr, "Can't make directory %s\n", filename + 1);
		} else if (link(filename, filename + 1) == 0) {
			// Nothing to do.
		} else if (S_ISLNK(buf.st_mode)) {
			static char buffer[MAX_FILENAME_LEN];
			memset(buffer, 0, sizeof(buffer));
			ret = readlink(filename, buffer, sizeof(buffer) - 1);
			if (ret > 0 && ret < sizeof(buffer) - 1) ret = symlink(buffer, filename + 1);
			if (ret) fprintf(stderr, "Can't make symlink %s\n", filename + 1);
		} else {
			ret = mknod(filename + 1, buf.st_mode, buf.st_rdev);
			ret |= chown(filename + 1, buf.st_uid, buf.st_gid);
			if (ret) fprintf(stderr, "Can't make node %s\n", filename + 1);
		}
	} else {
		if (buf.st_mode != buf2.st_mode && chmod(filename + 1, buf.st_mode)) fprintf(stderr, "chmod %o %s: %s\n", buf.st_mode, filename + 1, strerror(errno));
		if ((buf.st_uid != buf2.st_uid || buf.st_gid != buf2.st_gid) && chown(filename + 1, buf.st_uid, buf.st_gid)) fprintf(stderr, "chown %d.%d %s: %s\n", buf.st_uid, buf.st_gid, filename + 1, strerror(errno));
	}
	return 0;
}

static int IsSymlink(char *filename, int buflen, char *trailer) {
	struct stat buf;
	if (lstat(filename, &buf) == 0 && S_ISLNK(buf.st_mode)) {
		static char buffer[MAX_FILENAME_LEN];
		int len;
		memset(buffer, 0, sizeof(buffer));
		len = readlink(filename, buffer, sizeof(buffer) - 1);
		if (len > 0 && len < sizeof(buffer) - 1) {
			static char new_filename[MAX_FILENAME_LEN];
			memset(new_filename, 0, sizeof(new_filename));
			if (buffer[0] != '/') {
				char *cp2 = strrchr(filename, '/');
				*cp2 = '\0';
				len = strlen(filename);
				if (len == 0) {
					strncpy(new_filename, "/", sizeof(new_filename) - 1);
				} else {
					strncpy(new_filename, filename, sizeof(new_filename) - 1);
					strncat(new_filename, "/", sizeof(new_filename) - 1 - strlen(new_filename));
				}
				*cp2 = '/';
			}
			strncat(new_filename, buffer, sizeof(new_filename) - 1 - strlen(new_filename));
			if (trailer != NULL && *trailer != '\0') {
				if (new_filename[strlen(new_filename) - 1] != '/') strncat(new_filename, "/", sizeof(new_filename) - 1 - strlen(new_filename));
				strncat(new_filename, trailer, sizeof(new_filename) - 1 - strlen(new_filename));
				printf("%s/%s -> %s\n", filename, trailer, new_filename);
			} else {
				printf("%s -> %s\n", filename, new_filename);
			}
			memset(filename, 0, buflen);
			strncpy(filename, new_filename, buflen - 1);
			return 1;
		}
	}
	return 0;
}

static int LinkFiles(void) {
	char filename[MAX_FILENAME_LEN];
	int pos, c;
 next_file: ;
	pos = 0;
	while((c = getc(stdin)) != EOF) {
		//if (c == '\n') c = '\0';
		filename[pos++] = (char) c;
		if (pos >= sizeof(filename) - 1) {
			fprintf(stderr, "Unexpected error: filename too long.\n");
			exit(1);
		}
		if (c != '\0') continue;
		pos = 0;
		if (filename[0] != '/' || filename[1] == '\0') goto next_file;
		printf("%s\n", filename);
	follow_symlink: ;
		char *cp = filename + 1;
		while (*cp != '\0') {
			if (*cp == '/') {
				*cp = '\0';
				MakeLink(filename);
				if (IsSymlink(filename, sizeof(filename), cp + 1)) goto follow_symlink;
				*cp = '/';
			}
			cp++;
		}
		MakeLink(filename);
		if (IsSymlink(filename, sizeof(filename), NULL)) goto follow_symlink;
	}
	fflush(stdout);
	return 0;
}

int main(int argc, char *argv[]) {
	int i;
	if (argc < 2) {
		fprintf(stderr, "Usage:  %s DestDir < filelist_to_copy\n", argv[0]);
		return 1;
	}
	if (chdir(argv[1]) != 0) {
		fprintf(stderr, "Can't chdir to %s\n", argv[1]);
		return 1;
	}
	//fprintf(stderr, "Linking files and directories to %s\n", dest);
	fprintf(stderr, "Starting ...\n");
	umask(0);
	i = LinkFiles();
	fprintf(stderr, "... Done!\n");
	return i;
}
