/*
 * Decompiled with CFR 0.152.
 */
package dom;

import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSParserFilter;
import org.w3c.dom.ls.LSSerializer;

public class DOM3
implements DOMErrorHandler,
LSParserFilter {
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    static LSParser builder;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            DOM3.printUsage();
            System.exit(1);
        }
        try {
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)dOMImplementationRegistry.getDOMImplementation("LS"));
            builder = dOMImplementationLS.createLSParser((short)1, null);
            DOMConfiguration dOMConfiguration = builder.getDomConfig();
            DOM3 dOM3 = new DOM3();
            DOM3 dOM32 = new DOM3();
            builder.setFilter(dOM32);
            dOMConfiguration.setParameter("error-handler", dOM3);
            dOMConfiguration.setParameter("validate", Boolean.TRUE);
            dOMConfiguration.setParameter("schema-type", "http://www.w3.org/2001/XMLSchema");
            dOMConfiguration.setParameter("schema-location", "personal.xsd");
            System.out.println("Parsing " + stringArray[0] + "...");
            Document document = builder.parseURI(stringArray[0]);
            dOMConfiguration = document.getDomConfig();
            dOMConfiguration.setParameter("error-handler", dOM3);
            dOMConfiguration.setParameter("validate", Boolean.TRUE);
            dOMConfiguration.setParameter("schema-type", "http://www.w3.org/2001/XMLSchema");
            dOMConfiguration.setParameter("schema-location", "data/personal.xsd");
            dOMConfiguration.setParameter("comments", Boolean.FALSE);
            System.out.println("Normalizing document... ");
            document.normalizeDocument();
            LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
            System.out.println("Serializing document... ");
            dOMConfiguration = lSSerializer.getDomConfig();
            dOMConfiguration.setParameter("xml-declaration", Boolean.FALSE);
            LSOutput lSOutput = dOMImplementationLS.createLSOutput();
            lSOutput.setByteStream(System.out);
            lSSerializer.write(document, lSOutput);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.DOM3 uri ...");
        System.err.println();
        System.err.println("NOTE: You can only validate DOM tree against XML Schemas.");
    }

    public boolean handleError(DOMError dOMError) {
        short s = dOMError.getSeverity();
        if (s == 2) {
            System.out.println("[dom3-error]: " + dOMError.getMessage());
        }
        if (s == 1) {
            System.out.println("[dom3-warning]: " + dOMError.getMessage());
        }
        return true;
    }

    public short acceptNode(Node node) {
        return 1;
    }

    public int getWhatToShow() {
        return 1;
    }

    public short startElement(Element element) {
        return 1;
    }
}

