package jp.osoite.tomu.itree;

public interface ITree {
    //メモString sensorTypesは扱わない。Rectangle2Dも今回は使わない。

    /** sensoridをセットする。領域は中央の点x1,y1からx2,y2と領域の中心から端まで矩形かえされる。*/
    public boolean insertSensorID(long sensorID, double lat_1, double lon_1, double lat_2, double lon_2);

    /** idが有無をチェックする。*/
    public boolean isAvailableSensorID(long sensorID);

    /** sqlに挿入するid list を取得する , 区切り　101,302,303,104,105 (デバッグ用なので今後util関数へ移動)*/
    public String searchSensorIDinCommaList(long lat, double lat_1, double lon_1, double lat_2, double lon_2);

    /** sqlに挿入するid list を取得する , long配列 */
    public long[] searchSensoorIDList(long lat, long lon, double lat_1, double lon_1, double lat_2, double lon_2);

    /* ITree elesementを全部表示 printf　debug */
    public long[] getAllTreeElements();

    /* ITree elesementを全部表示 printfなんでもいい。とりあえず出す。　debug */
    public String printAllTreeElements();

    /* ITreeからidを消去してもらう。*/
    public boolean deleteSensorID(long sensorID);

    /* ITreeから全idを消去してもらう。*/
    public boolean deleteAllSensorIDs();

    /* ITreeで管理している個数 デバッグ用なくても良い*/
    public int getNumOfElement();
}
