package jp.osoite.tomu.itree.list;

import jp.osoite.tomu.itree.util.Constants;

public class BranchList implements Sortable
{
    private int entry_number;
    private float mindist;
    private float minmaxdist;
    private boolean section;

	private float compute_erg(Sortable s, int sortCriterion)
    {
    	float erg = (float)0.0;
        switch(sortCriterion)
        {
            case Constants.SORT_MINDIST:
                erg = this.getMindist() - ((BranchList)s).getMindist();
                break;
        }
        return erg;
    }
		    
    public boolean lessThan(Sortable s, int sortCriterion)
    {
        float erg = compute_erg(s, sortCriterion);
        if (erg < (float)0.0)    return true;
            return false;
    }
                
    public boolean greaterThan(Sortable s, int sortCriterion)
    {
        float erg = compute_erg(s, sortCriterion);
        if (erg > (float)0.0)
            return true;
        return false;
    }

	public void setMinmaxdist(float minmaxdist) {
		this.minmaxdist = minmaxdist;
	}

	public float getMinmaxdist() {
		return minmaxdist;
	}

	public void setMindist(float mindist) {
		this.mindist = mindist;
	}

	public float getMindist() {
		return mindist;
	}

	public void setEntry_number(int entry_number) {
		this.entry_number = entry_number;
	}

	public int getEntry_number() {
		return entry_number;
	}

	public void setSection(boolean section) {
		this.section = section;
	}

	public boolean isSection() {
		return section;
	}
}