/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.net.mail;

/**
 *
 * @author tailor
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * MailScheduleManager.java
 * java.util.Timerの使い方を検証するテストコード。
 * 一時停止、再開を行いたい。
 *
 * @author <a href="mailto:torutk@alles.or.jp">Toru TAKAHASHI</a>
 * @version $Id: MailScheduleManager.java 72 2007-05-09 23:19:38Z toru $
 */
public class MailScheduleManager {

    //private int dur_time=3;
    private static MailScheduleManager mailScheduleManager = new MailScheduleManager();
    private HashMap hmap;
    private ArrayList alist;;
    public static MailScheduleManager getInstance() {
        if (mailScheduleManager == null) {
            mailScheduleManager = new MailScheduleManager();
        }
        return mailScheduleManager;
    }
    //private String msgbody="";

    private MailScheduleManager() {
        timer = new Timer(true);
        time = new Time();
        hmap = new HashMap();
        alist= new ArrayList();
    }


    /*public void setAlartMessage(String msgbody) {
        this.msgbody = msgbody;
    }*/

    /**
     * Timerを開始(再開)する。
     * Timerに登録するTaskがnullであれば、新規にTaskを生成してから、これを
     * Timerにセットしている。再開時に前回の状態を引き継ぐため、Taskの生成
     * 時にtimeオブジェクトを渡している。
     * shedterm秒まってから繰り返し実行。
     */
    /*
    public void start(long shedterm) {
        //if (task == null) {
        //    task = new BasicTask2(new Time());//time
        //}
        task = new MailTask(new Time(), msgbody);//time
        System.out.println("Mail Alart is rsvd");
        timer.schedule(task, shedterm);
    }*/

    /**
     * Timerを開始(再開)する。
     * Timerに登録するTaskがnullであれば、新規にTaskを生成してから、これを
     * Timerにセットしている。再開時に前回の状態を引き継ぐため、Taskの生成
     * 時にtimeオブジェクトを渡している。
     */
    /*
    public void start() {
        //if (task == null) {
        //    task = new BasicTask2(new Time());//time
        //}
        task = new MailTask(new Time(), "");//time
        System.out.println("Mail Alart Taskを予約します");
        timer.schedule(task, 10 * 1000, 10 * 1000);

    }*/

    public void start(long sensorID, int shedterm,String msgbody) {

        //msgbody="###";
        MailTask task1 = new MailTask(new Time(), msgbody, sensorID);//time
        System.out.println("Mail Alart is rsvd");
        timer.schedule(task1, shedterm);

        
        if(alist.contains(sensorID)){
            //転送再開。
            ;
            JavaMailSend.getInstance().send_againmsg(msgbody,sensorID);
            removeResendWaitinList(sensorID);
        }

        hmap.put(sensorID, task1);

    }

    /**
     * Timerを停止する。
     * 実は、Timerに登録したTaskオブジェクトをcancelしてから破棄(=null)して
     * いる。
     */
    public void stop() {
        if (task != null) {
            task.cancel();
            task = null;
        //System.out.println("Mail Alartを停止しました");
        }
    }

    public void stop(long sensorID) {
        MailTask task1 = (MailTask) hmap.get(sensorID);
        if (task1 != null) {
            task1.cancel();
            hmap.remove(sensorID);
        }
        task = null;
    }

    public static void doJob() {

        MailScheduleManager tester = new MailScheduleManager();
        try {

            tester.start(1,3 * 60 * 1000 + 100,"#TESTMSG#");
            System.out.println(System.currentTimeMillis() % 1000000 + "_ST");
            Thread.sleep(50 * 1000);
            tester.stop();

            System.out.println(System.currentTimeMillis() % 1000000 + "_ED");
            Thread.sleep(5 * 1000);

            tester.start(1,3 * 60 * 1000 + 100,"#TESTMSG#");
            System.out.println(System.currentTimeMillis() % 1000000 + "_ST");
            Thread.sleep(5 * 60 * 1000 + 100);
            tester.stop();

        /*
        System.out.println(System.currentTimeMillis() % 1000000 + "_ED");
        Thread.sleep(5 * 1000);

        tester.start(10*1000);
        System.out.println(System.currentTimeMillis() % 1000000 + "_ST");
        Thread.sleep(15 * 1000);
        tester.stop();
        System.out.println(System.currentTimeMillis() % 1000000 + "_ED");
         */

        } catch (InterruptedException ex) {
            Logger.getLogger(MailScheduleManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean addResendWaitinList(long id){
        return alist.add(id);
    }
    public boolean removeResendWaitinList(long id){
        return alist.remove(id);
    }

    public static void doJob2() {

        MailScheduleManager tester = new MailScheduleManager();
        try {

            tester.start(1,1000,"#TESTMSG#");
            System.out.println(System.currentTimeMillis() % 1000000 + "_ST");
            Thread.sleep(5 * 1000);
            tester.stop();
            System.out.println(System.currentTimeMillis() % 1000000 + "_ED");
            Thread.sleep(5 * 1000);
            tester.start(1,1000,"#TESTMSG#");
            System.out.println(System.currentTimeMillis() % 1000000 + "_ST");
            Thread.sleep(20 * 1000);
            tester.stop(1);
            System.out.println(System.currentTimeMillis() % 1000000 + "_ED");
            Thread.sleep(5 * 1000);
            tester.start(1,1000,"#TESTMSG#");
            System.out.println(System.currentTimeMillis() % 1000000 + "_ST");
            Thread.sleep(15 * 1000);
            tester.stop(1);
            System.out.println(System.currentTimeMillis() % 1000000 + "_ED");

        } catch (InterruptedException ex) {
            Logger.getLogger(MailScheduleManager.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    /**
     * Timerのテストプログラムのmainメソッド。
     * 10秒毎に、テストの開始、終了を交互に呼び出す。
     *
     * @throws InterruptedException タイミングを取るためにThreadクラスの
     * ブロッキング・メソッドsleepを呼び出しているが、意図しないインタラプトが
     * 発生したときにスローする
     */
    public static void main(String[] args) throws InterruptedException {
        doJob();

    }
    /** 一定時間毎にタスクを起動するTimer */
    private Timer timer = null;
    /** Timerから一定時間毎に起動されるタスク */
    private MailTask task = null;
    /**  時刻を保持するオブジェクト */
    private Time time = null;
} // MailScheduleManager

/**
 * タイマから起動されるタスク。
 * 時刻を保持するTimeクラスを持ち、タイマから起動されるごとに、時刻を
 * 刻むため、Timeメソッドのtick()を呼び出す。
 */
class MailTask extends TimerTask {

    private Time time;
    String msgbody;
    long sensorID=0;

    public MailTask(Time aTime, String msgbody,long sensorID) {
        time = aTime;
        this.msgbody = msgbody;
        this.sensorID=sensorID;
    }

    public void run() {

        System.out.println("Mail送信タスクを実行しています。");
        time.tick();
        System.out.println("Second = " + time.getSecond());
        System.out.println(System.currentTimeMillis() % 1000000 + "_RN");

        JavaMailSend.getInstance().send_errmsg(3, msgbody,sensorID);
        MailScheduleManager.getInstance().addResendWaitinList(sensorID);

    }
}

/**
 * 時刻を保持するクラス。
 * サンプル用に秒だけを保持する簡易実装しかしていない。
 */
class Time {

    private int second = 0;

    public void tick() {
        second++;
    }

    public int getSecond() {
        return second;
    }
}
