

package jp.osoite.tomu.net.radio.sunspot;

import com.sun.spot.io.j2me.radiogram.Radiogram;
import com.sun.spot.io.j2me.radiogram.RadiogramConnection;
import jp.osoite.tomu.core.main.MainController;
import jp.osoite.tomu.core.db.DBConnectionModule;
import jp.osoite.tomu.core.main.IConnection;
import jp.osoite.tomu.core.main.SensorVals;
//import com.sun.spot.io.j2me.radiogram.*;

import com.sun.spot.util.IEEEAddress;
import javax.microedition.io.Connector;
import jp.osoite.tomu.usml.Config;


/**
 * This application is the 'on Desktop' portion of the SendDataDemo. 
 * This host application collects sensor samples sent by the 'on SPOT'
 * portion running on neighboring SPOTs and graphs them in a window. 
 *   
 * @author Vipul Gupta
 * modified Ron Goldman
 */
public class RconReceiverServer implements IConnection{
    // Broadcast port on which we listen for sensor samples
    //private static final int HOST_RECEIVE_PORT = 67;
    private static final int HOST_RECEIVE_PORT = Config.getInstance().getRCON_HOST_RECEIVE_PORT();
    
    private RadiogramConnection rCon;
    private boolean isLoop = true;
    //private static final int CONNECTION_TIMEOUT = 2*10*1000;
    
    public void setup() {
        //BaseJFrame fr = new BaseJFrame("Send Data Host App",this);
        //masa 27��
        //GuiCrtlMainFrame fr = new GuiCrtlMainFrame("Send Data Host App");


        //DataWindowController.getInstance().addDatabaseConnectionsListener(this);
        
        
    }
    
    
    public void run()  {
        
        Radiogram dg = null;
        try {
            // Open up a server-side broadcast radiogram connection
            // to listen for sensor readings being sent by different SPOTs
            rCon = (RadiogramConnection) Connector.open("radiogram://:" + HOST_RECEIVE_PORT);
            //rCon.setTimeout(CONNECTION_TIMEOUT);
            dg = (Radiogram)rCon.newDatagram(rCon.getMaximumLength());
            
            
        } catch (Exception e) {
             System.err.println("setUp caught " + e.getMessage());
             //System.exit(1);
        }

        MainController.getInstance().append("Listening...\n");

        int freq=0;
        float accelX=0;
        float accelY=0;
        float accelZ=0;
        float tiltX=0;
        float tiltY=0;
        float tiltZ=0;
        int rssi;
        String sensorname;
        //double moving=0.0;
        // Main data collection loop
        while (isLoop) {
            try {
                // Read sensor sample received over the radio

                rCon.receive(dg);
                
                long fromAddr=dg.getAddressAsLong();

                byte flag = dg.readByte();
                
                //long sensedCounter = dg.readLong();      // read time of the reading
                int sensedCounter = dg.readInt();      // read time of the reading
                //int lightSensorVal = dg.readInt();         // read the sensor value
                int lightSensorVal = (int)dg.readShort();         // read the sensor value
                //double remainingBattery=dg.readDouble();
                float remainingBattery=dg.readFloat();

                //double tempSensorVal=dg.readDouble();
                float tempSensorVal=dg.readFloat();

               /*
                double accelX=0;
                double accelY=0;
                double accelZ=0;
                accelX=dg.readDouble();
                accelY=dg.readDouble();
                accelZ=dg.readDouble();
                 */

                accelX=dg.readFloat();
                accelY=dg.readFloat();
                accelZ=dg.readFloat();
                tiltX=dg.readFloat();
                tiltY=dg.readFloat();
                tiltZ=dg.readFloat();
                
                rssi= dg.getRssi();
                //freq=5;
                freq =dg.readInt();
                //freq =dg.readShort();

                //SensorVals sval=new SensorVals(fromAddr,sensedCounter,tempSensorVal,accelX,accelY,accelZ,lightSensorVal,remainingBattery);
                sensorname=IEEEAddress.toDottedHex(fromAddr);

                if(RadioFilters.isFilterPass(sensorname)){
                    SensorVals sval=new SensorVals(fromAddr,sensorname,sensedCounter,tempSensorVal,accelX,accelY,accelZ,tiltX,tiltY,tiltZ,lightSensorVal,remainingBattery,freq,rssi);
                    //dw.addData(time,"ligt",lightSensorVal,"batt",(int)remainingBattery,"accy",(int)(accelY*100));
                    MainController.getInstance().addSensorVals(sval);
                }
                
                
                //DBConnectionModule.getInstance().receiveDataFromOutside(dg.getAddress(),ts,sval.getLightSensorVal());
                //DBConnectionModule.getInstance().receiveDataFromOutside(sval);
                
            } catch(java.io.InterruptedIOException ie){
                    System.err.println("Caught " + ie +  " while reading sensor samples in RConReceive");
        
            }            catch (Exception e) {
                System.err.println("Caught " + e +  " while reading sensor samples.");
            }
        }//loopend
    }

    public void closeOp(){
        isLoop=false;
        try {
            this.tearDown();
            DBConnectionModule.getInstance().tearDown();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
        

    public void tearDown() throws Exception {
        if (rCon != null) {
            
            rCon.close();
            
        }


    }

    /**
     * Start up the host application.
     *
     * @param args any command line arguments
     */
    public static void main(String[] args) throws Exception {
        RconReceiverServer app = new RconReceiverServer();
        app.setup();
        app.run();
    }
}
