/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.net.socks;

/**
 *
 * @author tailor
 */
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osoite.tomu.core.main.IConnection;
import jp.osoite.tomu.core.main.MainController;
import jp.osoite.tomu.core.main.SensorVals;

public class SockMultiThreadServer implements IConnection {

    public static final int SOCK_SERV_PORT = 5555;
    public ServerSocket serverSocket;
    int threadCount = 0;
    final List freeThreads = new ArrayList();
    //private static final int PORT = 5556;
    //private static final int CORE_THREADS = 10,  MAX_THREADS = 30;
    private static final int CORE_THREADS = 5,  MAX_THREADS = 20;

    public SockMultiThreadServer() {
    }

    public static void main(String argv[]) {

        new Thread(new SockMultiThreadServer()).start();

    }

    private void startThread() {
        WorkerThread worker = new WorkerThread();
        ++this.threadCount;
        worker.start();
    }

    class WorkerThread extends Thread {

        private Socket socket;

        // �\�P�b�g�ꄂ蓖�Ă�
        public synchronized void assign(Socket socket) {
            this.socket = socket;
            this.notify(); // ���\�b�hwait�őҋ@���̏�����ĊJ����
        }

        public synchronized void run() {
            for (;;) { // ���x��ė��p����̂ŁA�����[�v����
                // ���̃X���b�h��ҋ@���̃X���b�h�Ƃ��ēo�^����
                synchronized (SockMultiThreadServer.this) {
                    SockMultiThreadServer.this.freeThreads.add(this);
                    SockMultiThreadServer.this.notify();
                }
                try {
                    this.wait(); // ���\�b�hnotify���Ă΂��܂őҋ@����
                } catch (InterruptedException e) {
                    // ���荞�݂͎g��Ȃ��̂Ŗ�������
                }

                try {
                    try {
                        SockMultiThreadServer.this.process(this.socket);
                    } finally {
                        // �\�P�b�g�������Ă��Ȃ���Ε���
                        if (!this.socket.isClosed()) {
                            this.socket.close();
                        }
                    }
                } catch (Throwable e) {
                    // ��O�^�G���[�����������ꍇ
                    e.printStackTrace();
                }
                // �K�[�x�b�W�E�R���N�^��x�����邽�߂ɁA
                // �g��Ȃ��ϐ���null�����
                this.socket = null;
            }
        }
    }

    void process(Socket s) throws Exception {
        // �\�P�b�g�ɑ΂��鏈��
        ArrayList alist;
        int MAX = 10;
        SockMsgBox[] intarray = new SockMsgBox[MAX];
        for (int i = 0; i < MAX; i++) {
            intarray[i] = new SockMsgBox("" + i);
        }
        List list = Arrays.asList(intarray);
        alist = new ArrayList(list);

        ObjectInputStream ois = new ObjectInputStream(s.getInputStream());


        alist = (ArrayList) (ois.readObject());


        Iterator itr2 = alist.iterator();

        while (itr2.hasNext()) {
            SockMsgBox mbox = (SockMsgBox) itr2.next();



            if (mbox.SensorVals() != null) {
                SensorVals sval = mbox.SensorVals();
                sval.printConsl();
                MainController.getInstance().addSensorVals(sval);

            }

            mbox.setStmt(mbox.getStatement() + "_hoge");
            System.out.println("receive:" + mbox);
        }//while end

        ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
        oos.writeObject(alist);

        s.close();

    }

    public synchronized void run() {
        
        while (this.threadCount < CORE_THREADS) {
            this.startThread();
        }
        try {

            this.serverSocket = new ServerSocket(SOCK_SERV_PORT);
            MyIPChecker.myip();

            for (;;) {
                
                Socket socket = this.serverSocket.accept();
                while (this.freeThreads.isEmpty()) {
                    
                    if (this.threadCount < MAX_THREADS) {
                        this.startThread();
                    }
                    try {
                        this.wait();
                    } catch (InterruptedException e) {
                        
                    }
                }
                
                WorkerThread thread;
                thread = (WorkerThread) this.freeThreads.remove(this.freeThreads.size() - 1);
                thread.assign(socket);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run2() {
        System.out.println("SockMultiThreadServer is starting");
        try {
           
            serverSocket = new ServerSocket(SOCK_SERV_PORT);
            MyIPChecker.myip();

            //MainController.getInstance().append("Socke Server is started...\n");

            int j = 0;
            while (true) {
                j++;
                ArrayList alist;
                int MAX = 10;
                SockMsgBox[] intarray = new SockMsgBox[MAX];
                for (int i = 0; i < MAX; i++) {
                    intarray[i] = new SockMsgBox("" + i);
                }
                List list = Arrays.asList(intarray);
                alist = new ArrayList(list);


                try {
                    System.out.println(j + ":�N���C�A���g����̐ڑ���|�[�g5555�ő҂��܂�");
                    Socket s = serverSocket.accept();

                    //ArrayList<String> alist = new ArrayList<String>();

                    // ��M
                    if (!s.isClosed()) {
                        ObjectInputStream ois = new ObjectInputStream(s.getInputStream());


                        alist = (ArrayList) (ois.readObject());


                        Iterator itr2 = alist.iterator();

                        while (itr2.hasNext()) {
                            SockMsgBox sobj = (SockMsgBox) itr2.next();



                            if (sobj.SensorVals() != null) {
                                SensorVals sval = sobj.SensorVals();
                                sval.printConsl();
                                MainController.getInstance().addSensorVals(sval);

                            }

                            sobj.setStmt(sobj.getStatement() + "_hoge");
                            System.out.println("receive:" + sobj);
                        }//while end

                        ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
                        oos.writeObject(alist);

                        s.close();
                    } else {

                        Thread.sleep(10);

                    }

                } catch (Exception ex) {
                    System.err.println("err at while loop in server");
                    ex.printStackTrace();
                }


            }//while end
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeOp() {
        if (this.serverSocket != null) {
            System.err.print("colose at sock serv");
            try {
                serverSocket.close();
            } catch (IOException ex) {
                System.err.print("close sock err");
                ex.printStackTrace();
            //Logger.getLogger(SockMultiThreadServer.class.getName()).log(Level.SEVERE, null, ex);
            }

        }

    }
}

