package jp.osoite.tomu.net.xmpp;

import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
//import jp.osoite.tomu.net.xmpp.utils.MessageClassifier;
import jp.osoite.tomu.net.xmpp.utils.TomuSettings;
//import jp.osoite.tomu.util.*;
import jp.osoite.tomu.util.PatternMatcher;
import org.jivesoftware.smack.*;
import org.jivesoftware.smack.packet.Presence;

/**
 *
 * @author delux
 */
public class AxlibXMPPManager {

    /**
     * Singleton Pattern
     * XMPPメッセージ管理クラス
     **/
    private static AxlibXMPPManager xmppmanager;
    private static XMPPConnection con;
    private static Hashtable<String, Chat> chatHash;
    private Roster roster;
//	private TomuSettings tomusettings;
    //private MessageClassifier msgclassifier;
    private static long send_message_length = 0;

    private AxlibXMPPManager() {
        Roster.setDefaultSubscriptionMode(Roster.SubscriptionMode.accept_all);
//		tomusettings = TomuSettings.getInstance();
//        msgclassifier = new MessageClassifier();
        chatHash = new Hashtable<String, Chat>();

        login();
        join();
    }

    public static AxlibXMPPManager getInstance() {
        if (xmppmanager == null) {
            xmppmanager = new AxlibXMPPManager();
        }
        return xmppmanager;
    }

    public void login() {
        
        System.out.println("XMPP Login");
        ConnectionConfiguration config = new ConnectionConfiguration(
                TomuSettings.getInstance().getXmppHost(),
                TomuSettings.getInstance().getXmppPort(),
                TomuSettings.getInstance().getXmppService());
        con = new XMPPConnection(config);
        try {

            con.connect();
            con.login(TomuSettings.getInstance().getOwnUser(), TomuSettings.getInstance().getXmppPasswd());
            roster = con.getRoster();

            chatHash.clear();
            setRosterListener();

            for (RosterEntry entry : roster.getEntries()) {
                createChat(entry.getUser());
            }
        } catch (XMPPException e) {
            System.err.println("===============ログインに失敗しました。===============");
            e.printStackTrace();
            System.err.println("===============ログインに失敗しました。===============");
        }

    }

    private void join() {
        /*
        try
        {
        roster.removeEntry(roster.getEntry("tomuxmpp4@gmail.com"));
        }
        catch (XMPPException e)
        {
        e.printStackTrace();
        }
         */

        if (!TomuSettings.getInstance().getJoinUser().equals("null")) {
            createRosterEntry(TomuSettings.getInstance().getJoinUser());
        }
    }

    public void setRosterListener() {
        System.out.println("setRosterListener");
        roster.addRosterListener(new AxlibXMPPListener());
    }

    public void createChat(String address) {
        if (!chatHash.containsKey(address)) {
            System.out.println("createChat: " + address);
            Chat chat = con.getChatManager().createChat(address, new AxlibMessageListenerImple());

            chatHash.put(address, chat);
        }
    }

    public void deleteChat(String address) {
        if (chatHash.containsKey(address)) {
            chatHash.remove(address);
        }
    }

    public void receiveMessage(String msg) {
        /*
        TomuMessage tomuMsg = new TomuMessage();
        tomuMsg.setTomuMsg(msg);
        msgclassifier.switchMessage(tomuMsg);
         */
    }

    public synchronized void sendMessage(String address, String message) {
        if (chatHash.containsKey(address)) {
            if (roster.getPresence(address).isAvailable()) {
                Chat chat = chatHash.get(address);
                try {
//                    chat.sendMessage( message );
                    chat.sendMessage(PatternMatcher.replaceDotAndHttp(message));
                    try {
                        Thread.sleep(300);
                    } catch (InterruptedException ex) {
                        Logger.getLogger(AxlibXMPPManager.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } catch (XMPPException e) {
                    e.printStackTrace();
                }
                System.out.println("Send OK: " + address);
            } else {
                System.out.println("Not Available: " + address);
            }
        } else {
            System.out.println("Send False: " + address);
        }
    }

    public synchronized void sendMessageAll(String str) {
        if (roster != null) {
            for (RosterEntry entry : roster.getEntries()) {
                String address = entry.getUser();
                try {
                    if (chatHash.containsKey(address)) {
                        if (roster.getPresence(address).isAvailable()) {
                            Chat chat = chatHash.get(address);
//                            chat.sendMessage( str );
                            chat.sendMessage(PatternMatcher.replaceDotAndHttp(str));
                            System.out.println("Send OK: " + address + ":" + Calendar.getInstance().getTime().toString());
                            try {
                                Thread.sleep(300);
                            } catch (InterruptedException ex) {
                                Logger.getLogger(AxlibXMPPManager.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        } else {
                            System.out.println("Not Available: " + address);
                        }
                    } else {
                        System.out.println("Send False: " + address);
                    }
                } catch (XMPPException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void createRosterEntry(String entry) {
        roster.reload();
        try {
            roster.createEntry(entry, entry, null);
        } catch (XMPPException e) {
            e.printStackTrace();
        }
    }

    public void removeRoster(String address) {
        roster.reload();
        RosterEntry entry = roster.getEntry(address);
        if (entry != null) {
            try {
                roster.removeEntry(entry);
            } catch (XMPPException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Not Found. " + address);
        }
    }

    public void removeAllRoster() {
        roster.reload();
        for (RosterEntry rentry : roster.getEntries()) {
            try {
                roster.removeEntry(rentry);
            } catch (XMPPException e) {
                e.printStackTrace();
            }
        }
    }

    public void displayRoster() {
        if (roster == null) {
            System.out.println("Disconnect");
        } else {
            roster.reload();
            Collection<RosterEntry> entries = roster.getEntries();
            System.out.println("> Display XMPP Roster@XMPPParser---");
            System.out.println("Num of Entry: " + entries.size());
            int i = 1;
            for (RosterEntry entry : entries) {
                String address = entry.getUser();
                System.out.println(i + ": " + entry.getUser() + "  Available:" + roster.getPresence(address).isAvailable());
                i++;
            }
            System.out.println("-----------------------------------");
        }
    }

    public void disconnect() {
        try {
            con.disconnect();
            con = null;
            roster = null;
            chatHash.clear();
        } catch (java.lang.NullPointerException ne) {
            //ne.printStackTrace();
            System.err.println("logoff again");
        }
    }

    /**
     * Roster Listener
     */
    private class AxlibXMPPListener implements RosterListener {

        public void entriesAdded(Collection<String> addresses) {
            System.out.println("XMPP entry added!!@XMPPParser");
            displayRoster();
            for (String address : addresses) {
                System.out.println(address);
                createChat(address);
            }
        }

        public void entriesDeleted(Collection<String> addresses) {
            System.out.println("XMPP entry deleted!!@XMPPParser");
            for (String address : addresses) {
                deleteChat(address);
            }
        }

        public void entriesUpdated(Collection<String> addresses) {
            System.out.println("losterUpdate");
        }

        public void presenceChanged(Presence presence) {
            /*
            System.out.println( "Presence:" + presence.toString() );
            System.out.println( "Status:" + presence.getStatus());
            System.out.println( "PacketID:" + presence.getPacketID());
            System.out.println( "Type:" + presence.getType().toString());
            System.out.println( "Xmlns:" + presence.getXmlns());
             */
            int i = 0;
            for (String property : presence.getPropertyNames()) {
                System.out.println("Property " + i + " :" + property);
                i++;
            }

            System.out.println("losterChange");
        }
    }
}
