package jp.osoite.tomu.net.xmpp.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jp.osoite.tomu.net.xmpp.usmls.KskUSMLParser;



public class KskMembersManager {
	/**
	 * ネットワーク上�?Tomuのリストクラス
	 * 各Tomuへの更新通知も行う
	 **/ 

	private static KskMembersManager membersManager = new KskMembersManager();
    //private TomuSettings tomusettings;
	private KskUSMLParser usmlparser;
	private KskMessageCreator msgCreator;
	private Hashtable<String, Tomu> mlist;	//Tomus List

	private KskMembersManager(){
//		tomusettings = TomuSettings.getInstance();
		mlist = new Hashtable<String, Tomu>();
		msgCreator = new KskMessageCreator();
		usmlparser = new KskUSMLParser();
	}

	public static KskMembersManager getInstance(){
        if( membersManager == null )
        {
            membersManager = new KskMembersManager();
        }
		return membersManager;
	}

	public void init(){
		System.out.println("init@MembersManager");
		//read own usml_config file
		usmlparser.parseMessage(mlist, new File(TomuSettings.getInstance().getPositionOfUSMLConfig()));
		showMembersList(); //show

		if(!TomuSettings.getInstance().getJoinUser().equals("null")){
			try{ Thread.sleep(3000); }
			catch(Exception e){ }

			/* 101 */
			TomuMessageKskVersion joinMsg = new TomuMessageKskVersion();
			joinMsg.setMsgCode("101");
			joinMsg.setMsgID(new String("" + System.currentTimeMillis()));
			joinMsg.setDst(TomuSettings.getInstance().getJoinUser());
			joinMsg.setSrc(TomuSettings.getInstance().getOwnUser());
			joinMsg.setTomuList(mlist.values());
			msgCreator.createMessage(joinMsg);	
		}
	}

	/* 101 */
	public void join(TomuMessageKskVersion tomuMsg){
		System.out.println("join@MembersManager");
		usmlparser.parseMessage(mlist, tomuMsg.getMsgBody());

		showMembersList();	//show

		//101 -> 102
		TomuMessageKskVersion resnewcom = new TomuMessageKskVersion();
		resnewcom.setMsgCode("102");
		resnewcom.setMsgID(tomuMsg.getMsgID());
		resnewcom.setDst(tomuMsg.getSrc());
		resnewcom.setSrc(TomuSettings.getInstance().getOwnUser());
		resnewcom.setTomuList(mlist.values());
		msgCreator.createMessage(resnewcom);

		//101 -> 103
		ArrayList<String> txlist = getTransferList(tomuMsg);
		showList(txlist);	//show
		Iterator<String> iterator = txlist.iterator();
		while(iterator.hasNext()){
			TomuMessageKskVersion newcombcas = new TomuMessageKskVersion();
			newcombcas.setMsgCode("103");
			newcombcas.setMsgID(tomuMsg.getMsgID());
			newcombcas.setDst(iterator.next());
			newcombcas.setSrc(TomuSettings.getInstance().getOwnUser());
			ArrayList<Tomu> tomulist = new ArrayList<Tomu>();
			tomulist.add(mlist.get(tomuMsg.getSrc()));
			newcombcas.setTomuList(tomulist);
			msgCreator.createMessage(newcombcas);
		}
	}

	public void addMembersList(TomuMessageKskVersion tomuMsg){
		
	}

	public void deleteMembersList(){

	}

	public ArrayList<String> getTransferList(TomuMessageKskVersion tomuMsg){
		ArrayList<String> txlist = new ArrayList<String>();
		int code = Integer.parseInt(tomuMsg.getMsgCode());
		if(code == 101){	//newcom
			Enumeration<String> en = mlist.keys();
			while(en.hasMoreElements()){
				String id = en.nextElement();
				if(!(id.equals(tomuMsg.getSrc())) && !(id.equals(tomuMsg.getDst())))
					txlist.add(id);
			}	
		}
		//クエリ�??部転�?or 部�?���?
        return txlist;
	}

	public void showMembersList(){
		Collection<Tomu> tomus = mlist.values();
		int i = 1;
		System.out.println("> showMembersList@MembersManager---");
		for(Tomu tomu : tomus){
			System.out.println("-<No." + i + ">TomuID: " + tomu.getID());
			System.out.println("Cover Area: " + tomu.getCoverarea());
			System.out.println("Timespan: " + tomu.getTimespan());
			tomu.showSensorList();
			i++;
		}	
		System.out.println("-----------------------------------");
	}

	public void showList(List list){
		Iterator iterator = list.iterator();
		int i = 1;
		System.out.println("> showList@MembersManager----------");
		while(iterator.hasNext()){
			System.out.println(i + ": " + (String)iterator.next());
			i++;
		}
		System.out.println("-----------------------------------");
	}
}
