/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.net.xmpp.utils;

import java.util.Calendar;
import java.util.Random;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osoite.tomu.net.xmpp.AxlibXMPPManager;
import jp.osoite.tomu.net.xmpp.XMPPExecuterSensorSourceThread;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.JAXBConverter;
import jp.osoite.tomu.xml.jaxb.util.builder.DummyTomuMessageFactory;
import jp.osoite.tomu.xml.jaxb.util.builder.DummyTomuMessageFactory.DummyMessageType;

/**
 * XMPP デバッグコマンドクラス
 * @author tomu delux
 */
public class XMPPCommandHandler {

    XMPPExecuterSensorSourceThread xmppSSExecuter;
    private BufferedReader br;
    private static XMPPCommandHandler xmpp_handler;

    //private Thread thread;
    private XMPPCommandHandler() {
        br = new BufferedReader(new InputStreamReader(System.in));

        AxlibXMPPManager.getInstance();
        

        
        //  thread = new Thread( xmpp_handler );
        //  thread.start();
        //  System.out.println("XMPP Debugger");
        //System.out.println("=======Starting My id is:==================");
        this.cmd_whoami();
        System.out.println("=========Enter command or help >=============");
    }

    public static XMPPCommandHandler getInstance() {
        if (xmpp_handler == null) {
            xmpp_handler = new XMPPCommandHandler();

        }
        return xmpp_handler;
    }

    /**
     * デバッグ
     * @param str メッセージ
     */
    public void command(String str) {
        System.out.println("> Input from Keyboad: " + str);

        //start exit
        if (str.equals("exit:") || str.equals("quit:") || str.equals("down:") || str.equals("x:")) {
            this.cmd_logoff();
            sleepTime();
            System.exit(0);
        } //end exit
        //start help
        else if (str.indexOf("help:") > -1) {
            cmd_helps(str);
        } //end help
        else if (str.indexOf("whoami:") > -1) {
            cmd_whoami();
            cmd_myinfo();
        } else if (str.indexOf("show users:") > -1) {
            cmd_users();
        } else if (str.indexOf("show myinfo:") > -1) {
            cmd_myinfo();
        } else if (str.indexOf("ping:") > -1) {
            cmd_ping();
        } else if (str.indexOf("login:") > -1) {
            cmd_login(str);
        } else if (str.indexOf("login1:") > -1) {
            this.cmd_logoff();
            cmd_login("login:tomuxmpp1@gmail.com pass:osoiteTomu");
            this.cmd_whoami();
        } else if (str.indexOf("login2:") > -1) {
            this.cmd_logoff();
            cmd_login("login:tomuxmpp2@gmail.com pass:osoiteTomu");

        } else if (str.indexOf("login3:") > -1) {
            this.cmd_logoff();
            cmd_login("login:tomuxmpp3@gmail.com pass:osoiteTomu");
            this.cmd_whoami();
        } else if (str.indexOf("login4:") > -1) {
            this.cmd_logoff();
            cmd_login("login:tomuxmpp4@gmail.com pass:osoiteTomu");
            this.cmd_whoami();
        } else if (str.indexOf("logoff:") > -1) {
            cmd_logoff();
        } else if (str.indexOf("ss:") > -1) {
            cmd_ss(str);
        } else if (str.indexOf("ssstop:") > -1) {
            xmppSSExecuter.stopLoop();
        } else if (str.indexOf("to:") > -1) {
            int to = str.indexOf("to:");
            cmd_to(to, str);
        } else if (str.indexOf("add user:") > -1) {
            String address = str.substring(9);
            cmd_addUser(address);
        } else if (str.indexOf("remove user:") > -1) {
            String address = str.substring(12);
            cmd_removeUser(address);
        } else if (str.indexOf("loop:") > -1) {
            int loop = str.indexOf("loop:");
            cmd_loop(loop, str);
        } else if (str.indexOf("test:") > -1) {

            command("whoami");
            sleepTime();
            command("show users:");
            sleepTime();
            command("ping:");
            System.out.println("test2-------------------------------");
            sleepTime();
            System.out.println("test3-------------------------------");
            sleepTime();
            command("to:all tomu:");
            System.out.println("test4-------------------------------");
            sleepTime();
            command("to:all tomu:static");
            sleepTime();
            command("to:all tomu:upload");

        } else if (str.indexOf("test2:") > -1) {
            sleepTime();
            command("to:all tomu:upload");
        } else {
            if (!str.equals("")) {
                System.out.println(">" + str + "---- command not found...");
            }

        }
    }

    private void cmd_helps(String str) {
        if (str.length() < 6) {
            show_all_helps();
        } else {
            if (str.indexOf("whoami") > -1) {
                whoami_help();
            }
            if (str.indexOf("show users") > -1) {
                users_help();
            }
            if (str.indexOf("show myinfo") > -1) {
                myinfo_help();
            }
            if (str.indexOf("ping") > -1) {
                ping_help();
            }
            if (str.indexOf("login") > -1) {
                login_help();
            }
            if (str.indexOf("logoff") > -1) {
                logoff_help();
            }
            if (str.indexOf("to") > -1) {
                toMessage_help();
            }
            if (str.indexOf("add user") > -1) {
                addUser_help();
            }
        }
    }

    private void show_all_helps() {
        System.out.println("------- XMPPDebugger Command Help -------");
        System.out.println("\"help:\" Show Comannd Help. This Comannd.");
        System.out.println("\"exit: quit: down: x:\" quit tomucore.");
        System.out.println("\"whoami:\" Show this XMPP Address.");
        System.out.println("\"show users:\" Show XMPP users.");
        System.out.println("\"show myinfo:\" Show my information.");
        System.out.println("\"ping:\" conection check.");
        System.out.println("\"login:\" -------.");
        login_help();
        System.out.println("\"logoff:\" XMPP.");
        System.out.println("\"to:\" -------.");
        toMessage_help();
        System.out.println("\"add user:\" Add new member.");
        System.out.println("\"remove user:\" Remove member.");
        System.out.println("\"ss:\" Start SensorData Send.");
        System.out.println("\"ssstop:\" Stop SensorData Send.");
        System.out.println("\"loop:@@@ cmd:@@@\" Loop Command.");
//        System.out.println("\"test:\" test run all!");
    }

    private void sleepTime() {
        try {
            Thread.sleep(1000);
        } catch (InterruptedException ex) {
            Logger.getLogger(XMPPCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    private void whoami_help() {
        System.out.println("------- XMPPDebugger Command Help -------");
        System.out.println("\"whoami:\" Show this XMPP Address.");
    }

    private void cmd_whoami() {
        System.out.println("=======My Id is:==================");
        System.out.println(TomuSettings.getInstance().getOwnUser());
        System.out.println("==================================");

    }

    private void users_help() {
        System.out.println("------- XMPPDebugger Command Help -------");

    }

    private void cmd_users() {
        AxlibXMPPManager.getInstance().displayRoster();
    }

    private void myinfo_help() {
        System.out.println("------- XMPPDebugger Command Help -------");

    }

    private void cmd_myinfo() {
        System.out.println("MyID:" + TomuSettings.getInstance().getOwnUser());
    }

    private void ping_help() {
        System.out.println("------- XMPPDebugger Command Help -------");

    }

    private void cmd_ping() {

        toMessage("all", "<TomuMessage>ping from " + TomuSettings.getInstance().getOwnUser() + ":" + Calendar.getInstance().getTime().toString() + "</TomuMessage>");
    }

    private void login_help() {
        System.out.println("------- XMPPDebugger Command Help -------");
        System.out.println("\"login:\"");
        System.out.println("\"login:@@@ pass:@@@\"");
        System.out.println("\"login:0~9\"");
    /*
    System.out.println("\"login:tomuxmpp1@gmail.com pass:@@@\"");
    System.out.println("\"login1:tomuxmpp1@gmail.com pass:@@@\"");
    System.out.println("\"login2:tomuxmpp1@gmail.com pass:@@@\"");
    System.out.println("\"login3:tomuxmpp1@gmail.com pass:@@@\"");
     */
    }

    private void cmd_login(String str) {

        System.out.println("login:");

        int pass = str.indexOf("pass:");
        if (pass < 0) {
            if (str.length() != 6) {
                int num = Integer.parseInt(str.substring(6));
                String address = "tomuxmpp";
                address = address.concat(Integer.toString(num));
                address = address.concat("@gmail.com");
                TomuSettings.getInstance().setOwnUser(address);
                TomuSettings.getInstance().setXmppPasswd("osoiteTomu");
            }
        } else {
            String address = str.substring(6, pass - 1);
            String sPass = str.substring(pass + 5);
            TomuSettings.getInstance().setOwnUser(address);
            TomuSettings.getInstance().setXmppPasswd(sPass);
        }

        AxlibXMPPManager.getInstance().login();
    }

    private void logoff_help() {
        System.out.println("------- XMPPDebugger Command Help -------");

    }

    private void cmd_logoff() {
        AxlibXMPPManager.getInstance().disconnect();
        System.out.println("------- logoff done -------");
    }

    private void toMessage_help() {
        System.out.println("------- XMPPDebugger Command Help -------");
        System.out.println("\"to:@@@ body:@@@\"");
        System.out.println("\"to:@@@ tomu:\"");
        System.out.println("\"to:@@@ tomu:static|dynamic\"");
        System.out.println("\"to:@@@ tomu:human\"");
    }

    private void cmd_to(int to, String str) {
        int body = str.indexOf("body:");
        if (body > to) {
            String address = str.substring(to + 3, body - 1);
            String message = str.substring(body + 5);
            toMessage(address, message);
        }
        int tomu = str.indexOf("tomu:");
        if (tomu > to) {
            String address = str.substring(to + 3, tomu - 1);
            String message = str.substring(tomu + 5);
            /**
             * JAXB version
             */
            if (message.equals("dynamic") || message == null) {
                try {
                    TomuMessage query = DummyTomuMessageFactory.getAppsResponse(DummyMessageType.IMAGE);
                    String xml = JAXBConverter.convertToXml(query);
                    toMessage(address, xml);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (message.equals("static")) {
                try {
                    TomuMessage query = DummyTomuMessageFactory.getAppsResponse(DummyMessageType.TEMP);
                    String xml = JAXBConverter.convertToXml(query);
                    toMessage(address, xml);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (message.equals("human")) {
                try {
                    //TomuMessage query = TomuDummyMessageFactory.getAppsResponceStaticHumanSensor("dest@hoge.jp", "src@hoge.jp");
                    TomuMessage query = DummyTomuMessageFactory.getAppsResponse(DummyMessageType.PEDESTRIAN);
                    String xml = JAXBConverter.convertToXml(query);
                    toMessage(address, xml);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (message.equals("upload")) {
                try {
                    TomuMessage query = DummyTomuMessageFactory.getSourceUpload(DummyMessageType.PEDESTRIAN);
                    String xml = JAXBConverter.convertToXml(query);
                    toMessage(address, xml);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        tomu = str.indexOf("tomudynamic:");//same tomu:
        if (tomu > to) {
            String address = str.substring(to + 3, tomu - 1);
            /**
             * JAXB version
             */
            try {
                TomuMessage query = DummyTomuMessageFactory.getAppsResponse(DummyMessageType.IMAGE);
                String xml = JAXBConverter.convertToXml(query);
                toMessage(address, xml);
                
            } catch (Exception e) {
            }
        }

        tomu = str.indexOf("tomustatic:");
        if (tomu > to) {
            String address = str.substring(to + 3, tomu - 1);
            /**
             * JAXB version
             */
            try {
                TomuMessage query = DummyTomuMessageFactory.getAppsResponse(DummyMessageType.TEMP);
                String xml = JAXBConverter.convertToXml(query);
                toMessage(address, xml);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void cmd_loop(int loop, String str) {
        int cmd = str.indexOf("cmd:");
        if (cmd > loop) {
            int numLoop = Integer.parseInt(str.substring(loop + 5, cmd - 1));
            String message = str.substring(cmd + 4);
            for (int i = 0; i < numLoop; i++) {
                System.out.println("Loop:" + i);
                command(message);
            }
        }
    }

    private void cmd_ss(String str) {
        String tomuType = "human";
        int time = 10 * 1000;
        if (str.length() > 3) {
            int polling_time = str.indexOf("time:");
            String type;
            if (polling_time > -1) {
                System.out.println(str.substring(polling_time + 5));
                time = Integer.parseInt(str.substring(polling_time + 5));
                type = str.substring(3, polling_time - 1);
            } else {
                type = str.substring(3);
            }

            if ((type.equals("dynamic")) || (type.equals("static")) || (type.equals("human")) || (type.equals("upload"))) {
                tomuType = type;
            }
        }
        xmppSSExecuter = new XMPPExecuterSensorSourceThread(tomuType, time);
        xmppSSExecuter.start();
    }

    private void toMessage(String address, String message) {
        if (address.equals("all")) {
            System.out.println("Send All Message:" + message);
            AxlibXMPPManager.getInstance().sendMessageAll(message);

        } else {
            System.out.println("Send " + address + " Message:" + message);
            AxlibXMPPManager.getInstance().sendMessage(address, message);
        }
    }

    private void addUser_help() {
        System.out.println("------- XMPPDebugger Command Help -------");

    }

    private void cmd_addUser(String address) {
        AxlibXMPPManager.getInstance().createRosterEntry(address);
    }

    private void cmd_removeUser(String address) {
        if (address.equals("all")) {
            AxlibXMPPManager.getInstance().removeAllRoster();
        } else {
            AxlibXMPPManager.getInstance().removeRoster(address);
        }
    }

    private String getNormalString(int length) {
        String str = new String();
        for (int i = 0; i < length; i++) {
            str = str.concat("a");
        }
        return new String(str);
    }

    private String getRandomString(int length, long seed) {
        String str = new String();
        Random rnd = new Random();
        rnd.setSeed(seed);
        for (int i = 0; i < length; i++) {
            str = str.concat(Integer.toString(rnd.nextInt(10)));
        }
        return new String(str);
    }
}
