package jp.osoite.tomu.sensor.tscan.socks;

import jp.osoite.tomu.sensor.tscan.*;
import java.net.*;
import java.util.*;
import java.io.*;

/**
 * OSTコーディネータからデータを受け取るためのクラス
 * @author shima
 */
public class TScanCoordinaterReceiver implements Runnable {

    public static final int DEFAULT_PORT = 10001;
    public static final String DEFAULT_IP = "192.168.0.201";

    private volatile boolean isRunning;
    private List<TScanReceiveListener> listenerList;
    private String ip;
    private int port;

    public TScanCoordinaterReceiver(String ip, int port) {
        listenerList = new ArrayList<TScanReceiveListener>();
        this.port = port;
        this.ip = ip;
    }

    public TScanCoordinaterReceiver() {
        this(DEFAULT_IP, DEFAULT_PORT);
    }

    public void addTScanReceiveListener(TScanReceiveListener listener) {
        listenerList.add(listener);
    }

    public void removeTScanReceiveListener(TScanReceiveListener listener) {
        listenerList.remove(listener);
    }

    private void notifyTScanReceiveListener(TScanValue item) {
        for (TScanReceiveListener listener : listenerList) {
            listener.receive(item);
        }
    }

    public void stop() {
        isRunning = false;
    }

    public void run() {
        isRunning = true;
        Socket socket = null;
        String line;
        try {
            socket = new Socket(ip, port);
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while (isRunning) {
                if ((line = reader.readLine()) != null) {
                    try {
                        notifyTScanReceiveListener(new TScanValue(line));
                    } catch (IllegalArgumentException e) {
                    }
                }
            }
            socket.close();
        } catch (Exception e) {
        } finally {
            try {
                socket.close();
            } catch (IOException ex) {
            }
        }
    }
}
