package jp.osoite.tomu.sensor.tscan.socks;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osoite.tomu.core.main.MainController;
import jp.osoite.tomu.core.main.SensorVals;
import jp.osoite.tomu.sensor.tscan.TScanValue;

/**
 *
 * @author tailor
 */
public class TScanReceiverRunnable implements TScanReceiveListener, Runnable{

    public static ArrayList<String> alist = new ArrayList<String>();

    public TScanReceiverRunnable(){

        initFilter();
        TScanServerConnector tsc = new TScanServerConnector();
        tsc.addTScanReceiveListener(this);


        
    }


    public static void initFilter(){

       //alist.add("2100");
       //alist.add("2200");
       alist.add("2300");
       //alist.add("2400");
       //alist.add("2500");
       //alist.add("2600");
       //alist.add("2700");
       //alist.add("2800");
        
    }

    
    public static boolean isFilter(String comid){

        for(String id: alist){
            
            if(comid.equals(id)){
                System.out.println("comid,id=("+comid+","+id+")");
                return true;
            }
                
        }

       return false;
    }

    public void receive(TScanValue item) {

        int internal=0;

        System.out.print(" "+item.getLeafID()+",");
        //item.printConsole();
        
        if(isFilter(item.getLeafID())){
            System.out.println("");
            
            String ieeestr="1000:0000:0000:"+item.getLeafID();
            //String ieeestr="FFFF:FFFF:AAAA:0001";
            System.out.println("ieeestr:"+ieeestr);

            item.printConsole();
            System.out.println("============#=============");
            long lngieee =2300;//Integer.parseInt(ieeestr);//
            //lngieee =IEEEAddress.toLong(ieeestr);//なぜかエラーがおこりまくる。？
            System.out.println("============#2=============");
            System.out.println("lngieee:"+lngieee);
            
            SensorVals sval =new SensorVals(
                    item.getMeasurementTime(),
                    lngieee,
                    ieeestr,
                    internal++,
                    item.getTemperature(),
                    -1.0,
                    -1.0,                   
                    -1.0,
                    -1.0,
                    -1.0,
                    -1.0,
                    -1,
                    (double)item.getVoltage(),
                    10,//int freq,
                    item.getLQI()
                    );
            
                sval.printConsl();
                
            try {
                MainController.getInstance().addSensorVals(sval);
                //MainController.getInstance().addSensorVals(new SensorVals());
            } catch (Exception ex) {
                ex.printStackTrace();
                Logger.getLogger(TScanReceiverRunnable.class.getName()).log(Level.SEVERE, null, ex);
            }
            
        }
            
    }

    public void run() {
        while(true){
            try {
                Thread.sleep(10000);
            } catch (InterruptedException ex) {
                Logger.getLogger(TScanReceiverRunnable.class.getName()).log(Level.SEVERE, null, ex);
            }   
        }
    }

}
