package jp.osoite.tomu.xml.jaxb.test;


import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import jp.osoite.tomu.xml.jaxb.object.InitPedestrian;
import jp.osoite.tomu.xml.jaxb.object.InitTemperature;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.JAXBConverter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessagePrinter;
import jp.osoite.tomu.xml.jaxb.util.builder.AppsResponseBuilder;
import jp.osoite.tomu.xml.jaxb.util.builder.DummyTomuMessageFactory;
import jp.osoite.tomu.xml.jaxb.util.builder.DummyTomuMessageFactory.DummyMessageType;
import jp.osoite.tomu.xml.jaxb.util.builder.SfeerInitRequestBuilder;
import jp.osoite.tomu.xml.jaxb.util.builder.SfeerInitResponseBuilder;
import jp.osoite.tomu.xml.jaxb.util.builder.SfeerRequestBuilder;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis.Direction;

class Test {

    public static void main(String[] args) {
        // Sfeerテスト
        TomuMessagePrinter.print(buildSfeerInitResp());
        TomuMessagePrinter.print(buildSfeerInitReq());
        TomuMessagePrinter.print(buildSfeerRequest());

        // APPS_RESPONSEテスト
        TomuMessagePrinter.print(buildAppsResponse());
        TomuMessagePrinter.print(DummyTomuMessageFactory.getAppsResponse(DummyMessageType.TEMP));
        TomuMessagePrinter.print(DummyTomuMessageFactory.getAppsResponse(DummyMessageType.PEDESTRIAN));
        TomuMessagePrinter.print(DummyTomuMessageFactory.getAppsResponse(DummyMessageType.CO2));
        TomuMessagePrinter.print(DummyTomuMessageFactory.getAppsResponse(DummyMessageType.IMAGE));
        TomuMessagePrinter.print(DummyTomuMessageFactory.getAppsResponse(DummyMessageType.RANDOM));

        // SOURCE_UPLOADテスト
        TomuMessagePrinter.print(DummyTomuMessageFactory.getSourceUpload(DummyMessageType.TEMP));
        TomuMessagePrinter.print(DummyTomuMessageFactory.getSourceUpload(DummyMessageType.PEDESTRIAN));
        TomuMessagePrinter.print(DummyTomuMessageFactory.getSourceUpload(DummyMessageType.CO2));
        TomuMessagePrinter.print(DummyTomuMessageFactory.getSourceUpload(DummyMessageType.IMAGE));
        TomuMessagePrinter.print(DummyTomuMessageFactory.getSourceUpload(DummyMessageType.RANDOM));
    }

    
    private static TomuMessage buildSfeerInitResp() {
        SfeerInitResponseBuilder builder = new SfeerInitResponseBuilder("dest@test", "src@test", System.currentTimeMillis());
        double[] ds=new double[5];
        ds[0]=0.1;
        InitTemperature initTemp = builder.getInitTemperature(System.currentTimeMillis(), 2.0, 2.0, 1.0, 1.5, ds);
        //InitTemperature initTemp = builder.getInitTemperature(System.currentTimeMillis(), 10.0, 10.0, 10.0, new double[]{0.1, 0.2, 0.3, 0.4, 0.5});
        InitPedestrian initPed = builder.getInitPedestrian(System.currentTimeMillis(), 1, 1, 1.0);
        builder.addArea(1, initTemp, initPed);
        return builder.build();
    }

    private static TomuMessage buildSfeerInitReq() {
        SfeerInitRequestBuilder builder = new SfeerInitRequestBuilder("dest@test", "src@test", System.currentTimeMillis());
        builder.addArea(1, 10.1, 10.1, 100, 200, 300);
        builder.addArea(2, 10.1, 10.1, 100, 200, 300);
        return builder.build();
    }

    private static TomuMessage buildSfeerRequest() {
        SfeerRequestBuilder builder = new SfeerRequestBuilder("dest@test", "src@test", System.currentTimeMillis(), System.currentTimeMillis());
        builder.addFlowSensorId(System.currentTimeMillis());
        builder.addTempSensorId(System.currentTimeMillis());
        builder.addTempSensorId(System.currentTimeMillis());
        builder.addLocation(10.1, 10.1, 100);
        return builder.build();
    }

    private static TomuMessage buildAppsResponse() {
        long tmp = System.currentTimeMillis();
        AppsResponseBuilder builder = new AppsResponseBuilder("dest@test", "src@test", tmp, tmp);
        builder.addTemperatureSensor(tmp, 30.0, tmp);
        builder.addHumiditySensor(tmp, 40.0, tmp);
        builder.addCO2Sensor(tmp, 50.0, tmp);
        Axis mainAxis = new Axis();
        
        mainAxis.setValue(180, 5, 10.,Direction.PLUS);
        mainAxis.setValue(180, 5, 10.,Direction.MINUS);
        //mainAxis.setPlusValue(180, 5, 10.);
        //mainAxis.setMinusValue(180, 5, 10.);
        builder.addPedestrianSensor(tmp, tmp, tmp, 10, mainAxis);
        builder.addInterPedestrianSensor(tmp, tmp, tmp, 10, mainAxis, mainAxis);
        try {
            URL url = new URL("http://hoge.hoge/test.jpg");
            builder.addImageSensor("hoge camera", tmp, 180, 10.1, 20.2, url, url);
        } catch (MalformedURLException ex) {
        }
        return builder.build();
    }

    private static void printXML(TomuMessage mes) {
        try {
            System.out.println("------------------------");
            System.out.println(JAXBConverter.convertToXml(mes));
        } catch (JAXBException ex) {
        }
    }
}
