package jp.osoite.tomu.xml.jaxb.util.builder;

import java.math.BigDecimal;
import jp.osoite.tomu.xml.jaxb.object.Location;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.InitializeException;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageType;

/**
 * KitoKito用アップロードデータJAXBオブジェクトを構築するクラスです．<br>
 * 各種セッターメソッドを利用してJAXBオブジェクトを構築します．
 * @author shima
 */
public class Kito2UploadDataBuilder {

    private JAXBConstructor cnst;
    private Location loc;
    private long sensorID;
    private int dir;
    private int dpi;
    private String imageUrl;
    private String thumbnail;
    private long sensedTime;

    /**
     * コンストラクタ
     * @param dest 送信先アドレス
     * @param src 発信元アドレス
     * @param msgId メッセージID
     * @param msgSeq メッセージシーケンス番号
     */
    public Kito2UploadDataBuilder(String dest, String src, long msgId, long msgSeq) {
        cnst = new JAXBConstructor(TomuMessageType.SOURCE_UPLOAD);
        cnst.setHeader(dest, src, msgId);
        cnst.setSequence(msgSeq);
    }

    /**
     * きときとアップロード用データのTomuMessageを構築します．
     * @return TomuMessageオブジェクト
     */
    public TomuMessage build() {
        cnst.addKitokitoData(sensorID, dir, loc, dpi, imageUrl, thumbnail, sensedTime);
        TomuMessage mes = null;
        try {
            mes = cnst.build();
        } catch (InitializeException ex) {
        }
        return mes;
    }

    /**
     * 方向を設定します．北から0度とし，359度で方角を表します．
     * @param dir 角度(360度)
     */
    public void setDirection(int dir) {
        this.dir = dir;
    }

    /**
     * 解像度を設定します．
     * @param dpi 解像度（dpi）
     */
    public void setDpi(int dpi) {
        this.dpi = dpi;
    }

    /**
     * 画像のURLを設定します．
     * @param imageUrl 画像URL
     * @param thumbnail サムネイル画像URL
     */
    public void setImageUrl(String imageUrl, String thumbnail) {
        this.imageUrl = imageUrl;
        this.thumbnail = thumbnail;
    }

    /**
     * 撮影時刻を設定します．
     * @param sensedTime 撮影時刻をUNIXTimeに変換した値
     */
    public void setSensedTime(long sensedTime) {
        this.sensedTime = sensedTime;
    }

    /**
     * きときとクライアントIDを設定します．
     * @param sensorID
     */
    public void setSensorID(long sensorID) {
        this.sensorID = sensorID;
    }

    /**
     * 緯度経度を設定します．
     * @param lat 緯度
     * @param lon 経度
     */
    public void setLocation(double lat, double lon) {
        loc = new Location();
        loc.setLat(BigDecimal.valueOf(lat));
        loc.setLon(BigDecimal.valueOf(lon));
    }
}
