package jp.osoite.tomu.xml.jaxb.util.builder;

import java.math.BigInteger;
import jp.osoite.tomu.xml.jaxb.object.ImageSet;
import jp.osoite.tomu.xml.jaxb.object.PedestrianSet;
import jp.osoite.tomu.xml.jaxb.object.TemperatureSet;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageType;

/**
 * SfeerサーバのRequestメッセージを構築します．
 * @author shima
 */
public class SfeerRequestBuilder {

    private JAXBConstructor cnst;
    private TemperatureSet tempSet;
    private PedestrianSet pedSet;
    private ImageSet imgSet;

    /**
     * コンストラクタ
     * @param dest 送信先ID
     * @param src 送信元ID
     * @param msgId メッセージID
     * @param msgSeq メッセージシーケンス番号
     */
    public SfeerRequestBuilder(String dest, String src, long msgId, long msgSeq) {
        cnst = new JAXBConstructor(TomuMessageType.APPS_REQUEST);
        cnst.setHeader(dest, src, msgId);
        cnst.setSequence(msgSeq);
    }

    /**
     * Sfeerサーバ用のRequestメッセージを構築します．
     * @return TomuMessageオブジェクト
     */
    public TomuMessage build() {
        cnst.addSfeerServerRequestData(tempSet, pedSet, imgSet);
        try {
            return cnst.build();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 温度センサのIDを追加します．
     * @param id センサID
     */
    public void addTempSensorId(long id){
        if(tempSet == null){
            tempSet = new TemperatureSet();
        }
        tempSet.getStaticSensorID().add(BigInteger.valueOf(id));
    }

    /**
     * 人流センサのIDを追加します．
     * @param id センサID
     */
    public void addFlowSensorId(long id){
        if(pedSet == null){
            pedSet = new PedestrianSet();
        }
        pedSet.getStaticSensorID().add(BigInteger.valueOf(id));
    }

    /**
     * 位置と範囲情報を追加します．
     * @param lat 緯度
     * @param lon 経度
     * @param radius 半径
     */
    public void addLocation(double lat, double lon, int radius){
        if(imgSet == null){
            imgSet = new ImageSet();
        }
        imgSet.getLocation().add(JAXBConstructor.getLocation(lon, lat, radius));
    }
}
