package jp.osoite.tomu.xml.jaxb.wrapper;

import java.util.ArrayList;
import java.util.List;
import jp.osoite.tomu.xml.jaxb.object.Area;
import jp.osoite.tomu.xml.jaxb.object.AreaSet;
import jp.osoite.tomu.xml.jaxb.object.Sfeer;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;

/**
 *
 * @author shima
 */
public class InitRequestSfeerWrapper extends TomuMessageWrapper {

    private Sfeer sfeer;
    private List<AreaSetting> areaList;

    public InitRequestSfeerWrapper(TomuMessage msg) {
        super(msg);
        sfeer = msg.getInitRequest().getSfeer();
        areaList = new ArrayList<AreaSetting>();
        init(sfeer.getAreaSet());
    }
    
    private void init(AreaSet areaSet){
        List<Area> list = areaSet.getArea();
        for(Area area : list){
            AreaSetting tmp = new AreaSetting(area.getAreaId().intValue(),
                    area.getLocation().getLat().doubleValue(),
                    area.getLocation().getLon().doubleValue(),
                    area.getLocation().getRadius().intValue(),
                    area.getTimeSpan().getBegin().longValue(),
                    area.getTimeSpan().getEnd().longValue());
            areaList.add(tmp);
        }
    }

    public List<AreaSetting> getAreaSettingList(){
        return areaList;
    }
}
