package jp.osoite.tomu.xml.jaxb.wrapper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jp.osoite.tomu.xml.jaxb.object.Area;
import jp.osoite.tomu.xml.jaxb.object.AreaSet;
import jp.osoite.tomu.xml.jaxb.object.InitPedestrian;
import jp.osoite.tomu.xml.jaxb.object.InitTemperature;
import jp.osoite.tomu.xml.jaxb.object.Sfeer;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.wrapper.AreaInitValues.PedestrianInitValue;
import jp.osoite.tomu.xml.jaxb.wrapper.AreaInitValues.TemperatureInitValue;

/**
 *
 * @author shima
 */
public class InitResponseSfeerWrapper extends TomuMessageWrapper {

    private Sfeer sfeer;
    private List<AreaInitValues> areaList;

    public InitResponseSfeerWrapper(TomuMessage msg) {
        super(msg);
        sfeer = msg.getInitResponse().getSfeer();
        areaList = new ArrayList<AreaInitValues>();
        init(sfeer.getAreaSet());
    }

    private void init(AreaSet areaSet) {
        List<Area> list = areaSet.getArea();
        for (Area area : list) {
            AreaInitValues initVals = new AreaInitValues(area.getAreaId().intValue());
            InitTemperature initTemp = area.getInitTemperature();
            if (initTemp != null) {
                List<BigDecimal> fiveMinList = initTemp.getFiveMinuteTempData().getTempValue();
                double[] fiveMinArr = new double[fiveMinList.size()];
                int counter = 0;
                for (BigDecimal val : fiveMinList) {
                    fiveMinArr[counter++] = val.doubleValue();
                }
                TemperatureInitValue tempVals = initVals.new TemperatureInitValue(
                        initTemp.getStaticSensorID().longValue(),
                        initTemp.getCurrentTempValue().doubleValue(),
                        initTemp.getMaxTempValue().doubleValue(),
                        initTemp.getMinTempValue().doubleValue(),
                        initTemp.getAvgTempValue().doubleValue(),
                        fiveMinArr);
                initVals.setTemperatureInitValue(tempVals);
            }
            InitPedestrian initPed = area.getInitPedestrian();
            if (initPed != null) {
                PedestrianInitValue pedVals = initVals.new PedestrianInitValue(
                        initPed.getStaticSensorID().longValue(),
                        initPed.getCurrentFlowValue().intValue(),
                        initPed.getCurrentResidentValue().intValue(),
                        initPed.getAvgFlowValue().doubleValue());
                initVals.setPedestrianInitValue(pedVals);
            }
            areaList.add(initVals);
        }
    }

    public List<AreaInitValues> getAreaSettingList() {
        return areaList;
    }
}
