package jp.osoite.tomu.xml.jaxb.wrapper;

import java.util.ArrayList;
import java.util.List;
import jp.osoite.tomu.xml.jaxb.object.DynamicSensorData;
import jp.osoite.tomu.xml.jaxb.object.SensorDataSet;
import jp.osoite.tomu.xml.jaxb.object.StaticSensorData;
import jp.osoite.tomu.xml.jaxb.object.StreetPedestrianFlowValue;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.SensorType;

/**
 *
 * @author shima
 */
public class ResponseAppsWrapper extends TomuMessageWrapper {

    private long msgSeq;
    private List<TemperatureSensor> tempList;
    private List<PedestrianSensor> pedList;
    private List<ImageSensor> imgList;

    public ResponseAppsWrapper(TomuMessage msg) {
        super(msg);
        tempList = new ArrayList<TemperatureSensor>();
        pedList = new ArrayList<PedestrianSensor>();
        imgList = new ArrayList<ImageSensor>();
        init(msg.getResponse().getSensorDataSet());
    }

    private void init(SensorDataSet sds) {
        msgSeq = sds.getSeq().longValue();
        List<StaticSensorData> ssd = sds.getStaticSensorData();
        if (ssd.size() != 0) {
            for (StaticSensorData data : ssd) {
                if (data.getType().equals(SensorType.TEMP.toString())) {
                    TemperatureSensor temp = new TemperatureSensor();
                    temp.sensorId = data.getStaticSensorID().longValue();
                    temp.sensedTime = data.getSensedTime().longValue();
                    temp.value = data.getValue().getTempValue().doubleValue();
                    tempList.add(temp);
                } else if (data.getType().contains(SensorType.PEDESTRIAN.toString())) {
                    PedestrianSensor ped = new PedestrianSensor();
                    ped.sensorId = data.getStaticSensorID().longValue();
                    ped.sensedTime = data.getSensedTime().longValue();
                    StreetPedestrianFlowValue spfv = data.getValue().getStreetPedestrianFlowValue();
                    ped.measurementTime = spfv.getMeasurementTimeSec().longValue();
                    ped.residence = spfv.getResidence().intValue();
                    ped.cAxis = new Axis(spfv.getChiefAxis());
                    if (data.getType().equals(SensorType.INTER_PEDESTRIAN.toString())) {
                        ped.sAxis = new Axis(spfv.getSubAxis());
                    }
                    pedList.add(ped);
                }
            }
        }
        List<DynamicSensorData> dsd = sds.getDynamicSensorData();
        if (dsd.size() != 0) {
            for (DynamicSensorData data : dsd) {
                ImageSensor img = new ImageSensor();
                img.sensedTime = data.getSensedTime().longValue();
                img.sensorName = data.getSensorName();
                img.compass = data.getDirection().intValue();
                img.url = data.getUrlValue();
                img.thumbUrl = data.getThumbnailUrlValue();
                img.loc = new Location(data.getLocation().getLat().doubleValue(), data.getLocation().getLon().doubleValue(), 0);
                imgList.add(img);
            }
        }
    }

    public List<ImageSensor> getImageSensorList() {
        return imgList;
    }

    public List<PedestrianSensor> getPedestrianSensorList() {
        return pedList;
    }

    public List<TemperatureSensor> getTemperatureSensorList() {
        return tempList;
    }


    public class TemperatureSensor {

        private long sensorId;
        private long sensedTime;
        private double value;

        public long getSensedTime() {
            return sensedTime;
        }

        public long getSensorId() {
            return sensorId;
        }

        public double getValue() {
            return value;
        }
    }

    public class PedestrianSensor {

        private long sensorId;
        private long sensedTime;
        private long measurementTime;
        private int residence;
        private Axis cAxis = null;
        private Axis sAxis = null;

        public Axis getChiefAxis() {
            return cAxis;
        }

        public long getMeasurementTime() {
            return measurementTime;
        }

        public int getResidence() {
            return residence;
        }

        public Axis getSubAxis() {
            return sAxis;
        }

        public long getSensedTime() {
            return sensedTime;
        }

        public long getSensorId() {
            return sensorId;
        }
    }

    public class ImageSensor {

        private long sensedTime;
        private String sensorName;
        private Location loc;
        private int compass;
        private String url;
        private String thumbUrl;

        public int getCompass() {
            return compass;
        }

        public Location getLocation() {
            return loc;
        }

        public long getSensedTime() {
            return sensedTime;
        }

        public String getSensorName() {
            return sensorName;
        }

        public String getThumbnailUrl() {
            return thumbUrl;
        }

        public String getUrl() {
            return url;
        }
    }
}
