package jp.osoite.tomu.xml.jaxb.wrapper;

import jp.osoite.tomu.xml.jaxb.object.StaticSensorData;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.SensorType;

/**
 *
 * @author shima
 */
public class UploadHumidityWrapper extends TomuMessageWrapper {

    private StaticSensorData ssd;

    public UploadHumidityWrapper(TomuMessage msg) {
        super(msg);
        ssd = msg.getUpload().getSensorSourceDataSet().getStaticSensorData().get(0);
    }

    public SensorType getType() {
        return SensorType.HUMIDITY;
    }

    public long getSensorId() {
        return ssd.getStaticSensorID().longValue();
    }

    public long getSensedTime() {
        return ssd.getSensedTime().longValue();
    }

    public double getHumidity(){
        return ssd.getValue().getCO2Value().doubleValue();
    }
}
