package jp.osoite.tomu.xml.jaxb.wrapper;

import jp.osoite.tomu.xml.jaxb.object.StaticSensorData;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.SensorType;

/**
 *
 * @author shima
 */
public class UploadTempWrapper extends TomuMessageWrapper {

    private StaticSensorData ssd;

    public UploadTempWrapper(TomuMessage msg) {
        super(msg);
        ssd = msg.getUpload().getSensorSourceDataSet().getStaticSensorData().get(0);
    }

    public SensorType getType() {
        return SensorType.TEMP;
    }

    public long getSensorId() {
        return ssd.getStaticSensorID().longValue();
    }

    public long getSensedTime() {
        return ssd.getSensedTime().longValue();
    }

    public double getTemp(){
        return ssd.getValue().getTempValue().doubleValue();
    }
}
