/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.osoite.tomu.xmpp.core;

import javax.xml.bind.JAXBException;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.JAXBConverter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessagePrinter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageSwitchManager;
import jp.osoite.tomu.xmpp.core.MessageReceiver;

    public class XMPPMessageReceiverImple extends MessageReceiver {


        private TomuMessageSwitchManager switchManager;

        public XMPPMessageReceiverImple (){
            switchManager=new TomuMessageSwitchManager();
            
            switchManager.addInitRequestSfeerListener(new InitRequestSfeerListenerImple());
            switchManager.addRequestSfeerListener(new RequestSfeerListenerImple());
            switchManager.addUploadKito2Listener(new UploadKito2ListenerImple());
            switchManager.addUploadPedestrianListener(new UploadPedestrianListenerImple());

        }
        

        public void receive(String message) {
            if (message.contains("[Ping]")) {
                System.out.println(message);
                String account = message.substring(message.indexOf("#") + 1);
                //manager.send(account, " * Hello, " + setting.getAccount() + " received your ping message.");
            } else {
                try {

                    TomuMessage tomuMsg = JAXBConverter.convertToObj(message);
                    TomuMessagePrinter.print(tomuMsg);
                    switchManager.switchMessage(tomuMsg);
                    
                } catch (JAXBException ex) {
                    System.out.println(message);
                }
            }
        }
    }
